/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.create;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropRecipes;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalcustomization.MysticalCustomization;
import com.blakebr0.mysticalcustomization.loader.CropLoader;
import com.blakebr0.mysticalcustomization.util.ParsingUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class CropCreator {
    public static Crop create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        String tierId = GsonHelper.m_13906_((JsonObject)json, (String)"tier");
        String typeId = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        CropTier tier = MysticalAgricultureAPI.getCropRegistry().getTierById(new ResourceLocation(tierId));
        if (tier == null) {
            throw new JsonSyntaxException("Invalid crop tier provided: " + tierId);
        }
        CropType type = MysticalAgricultureAPI.getCropRegistry().getTypeById(new ResourceLocation(typeId));
        if (type == null) {
            throw new JsonSyntaxException("Invalid crop type provided: " + typeId);
        }
        JsonObject ingredient = json.has("ingredient") ? GsonHelper.m_13930_((JsonObject)json, (String)"ingredient") : null;
        LazyIngredient material = LazyIngredient.EMPTY;
        if (ingredient != null) {
            if (ingredient.has("tag")) {
                String tag = GsonHelper.m_13906_((JsonObject)ingredient, (String)"tag");
                material = LazyIngredient.tag((String)tag);
            } else if (ingredient.has("item")) {
                String item = GsonHelper.m_13906_((JsonObject)ingredient, (String)"item");
                if (ingredient.has("nbt")) {
                    CompoundTag nbt = ParsingUtils.parseNBT(ingredient.get("nbt"));
                    material = LazyIngredient.item((String)item, (CompoundTag)nbt);
                } else {
                    material = LazyIngredient.item((String)item);
                }
            } else {
                throw new JsonSyntaxException("Ingredient must have either 'item' or 'tag' property");
            }
        }
        Crop crop = new Crop(id, tier, type, material);
        if (json.has("color")) {
            String color = GsonHelper.m_13906_((JsonObject)json, (String)"color");
            int i = ParsingUtils.parseHex(color, "color");
            crop.setColor(i);
        } else if (json.has("colors")) {
            int i;
            String color;
            JsonObject colors = GsonHelper.m_13930_((JsonObject)json, (String)"colors");
            if (colors.has("flower")) {
                color = GsonHelper.m_13906_((JsonObject)colors, (String)"flower");
                i = ParsingUtils.parseHex(color, "flower");
                crop.setFlowerColor(i);
            }
            if (colors.has("essence")) {
                color = GsonHelper.m_13906_((JsonObject)colors, (String)"essence");
                i = ParsingUtils.parseHex(color, "essence");
                crop.setEssenceColor(i);
            }
            if (colors.has("seeds")) {
                color = GsonHelper.m_13906_((JsonObject)colors, (String)"seeds");
                i = ParsingUtils.parseHex(color, "seeds");
                crop.setSeedColor(i);
            }
        }
        CropTextures ctextures = crop.getTextures().setFlowerTexture(CropTextures.FLOWER_INGOT_BLANK).setEssenceTexture(CropTextures.ESSENCE_INGOT_BLANK).setSeedTexture(CropTextures.SEED_BLANK);
        if (json.has("textures")) {
            ResourceLocation location;
            JsonObject textures = GsonHelper.m_13930_((JsonObject)json, (String)"textures");
            if (textures.has("flower")) {
                String texture = GsonHelper.m_13906_((JsonObject)textures, (String)"flower");
                location = new ResourceLocation(texture);
                ctextures.setFlowerTexture(location);
            }
            if (textures.has("essence")) {
                String texture = GsonHelper.m_13906_((JsonObject)textures, (String)"essence");
                location = new ResourceLocation(texture);
                ctextures.setEssenceTexture(location);
            }
            if (textures.has("seeds")) {
                String texture = GsonHelper.m_13906_((JsonObject)textures, (String)"seeds");
                location = new ResourceLocation(texture);
                ctextures.setSeedTexture(location);
            }
        }
        if (json.has("name")) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            crop.setDisplayName((Component)new TextComponent(name));
        }
        if (json.has("baseSecondaryChance")) {
            double chance = GsonHelper.m_144784_((JsonObject)json, (String)"baseSecondaryChance");
            crop.setBaseSecondaryChance(chance);
        }
        if (json.has("enabled")) {
            boolean enabled = GsonHelper.m_13912_((JsonObject)json, (String)"enabled");
            crop.setEnabled(enabled);
        }
        if (json.has("crux")) {
            String crux = GsonHelper.m_13906_((JsonObject)json, (String)"crux");
            CropLoader.CRUX_MAP.put(crop, new ResourceLocation(crux));
        }
        if (json.has("glint")) {
            boolean glint = GsonHelper.m_13912_((JsonObject)json, (String)"glint");
            crop.setHasEffect(glint);
        }
        if (json.has("biomes")) {
            JsonArray biomes = GsonHelper.m_13933_((JsonObject)json, (String)"biomes");
            biomes.forEach(biome -> crop.addRequiredBiome(new ResourceLocation(biome.getAsString())));
        }
        if (CropCreator.isGarbageSeed(crop.getName())) {
            RegistryObject essence = "insanium".equals(crop.getName()) ? RegistryObject.create((ResourceLocation)new ResourceLocation("mysticalagradditions", crop.getNameWithSuffix("essence")), (IForgeRegistry)ForgeRegistries.ITEMS) : RegistryObject.create((ResourceLocation)new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("essence")), (IForgeRegistry)ForgeRegistries.ITEMS);
            essence.updateReference(ForgeRegistries.ITEMS);
            crop.setEssenceItem((Supplier)essence);
            if (!essence.isPresent()) {
                MysticalCustomization.LOGGER.error("Could not find the essence for crop {}", (Object)crop.getId());
            }
        }
        if (json.has("essence")) {
            String essence = GsonHelper.m_13906_((JsonObject)json, (String)"essence");
            RegistryObject item = RegistryObject.create((ResourceLocation)new ResourceLocation(essence), (IForgeRegistry)ForgeRegistries.ITEMS);
            crop.setEssenceItem((Supplier)item);
        }
        if (json.has("recipes")) {
            JsonObject recipes = GsonHelper.m_13930_((JsonObject)json, (String)"recipes");
            CropRecipes config = crop.getRecipeConfig();
            if (recipes.has("crafting")) {
                boolean enabled = GsonHelper.m_13912_((JsonObject)recipes, (String)"crafting");
                config.setSeedCraftingRecipeEnabled(enabled);
            }
            if (recipes.has("infusion")) {
                boolean enabled = GsonHelper.m_13912_((JsonObject)recipes, (String)"infusion");
                config.setSeedInfusionRecipeEnabled(enabled);
            }
            if (recipes.has("reprocessor")) {
                boolean enabled = GsonHelper.m_13912_((JsonObject)recipes, (String)"reprocessor");
                config.setSeedReprocessorRecipeEnabled(enabled);
            }
        }
        return crop;
    }

    private static boolean isGarbageSeed(String name) {
        return "prudentium".equals(name) || "tertium".equals(name) || "imperium".equals(name) || "supremium".equals(name) || "awakened_supremium".equals(name) || "insanium".equals(name) || "fertilized".equals(name);
    }
}

