/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.api.jda;

import io.github.lightman314.lightmansdiscord.LightmansDiscordIntegration;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeGuildReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeUserReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafeTextChannelReference;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Activity;

public class JDAUtil {
    private JDAUtil() {
    }

    @Nullable
    public static JDA getJDA() {
        return LightmansDiscordIntegration.PROXY.getJDA();
    }

    @Nullable
    public static SafeGuildReference getGuild(String guildID) {
        if (guildID == null) {
            return null;
        }
        JDA jda = JDAUtil.getJDA();
        if (jda != null) {
            return SafeGuildReference.of(jda.getGuildById(guildID));
        }
        return null;
    }

    @Nullable
    public static SafeUserReference getUser(String userID) {
        if (userID == null) {
            return null;
        }
        JDA jda = JDAUtil.getJDA();
        if (jda != null) {
            return SafeUserReference.of(jda.getUserById(userID));
        }
        return null;
    }

    @Nullable
    public static SafeMemberReference getMember(@Nullable SafeGuildReference guild, String userID) {
        if (guild != null) {
            return guild.getMember(userID);
        }
        return null;
    }

    @Nullable
    public static SafeTextChannelReference getTextChannel(String channelID) {
        if (channelID == null) {
            return null;
        }
        JDA jda = JDAUtil.getJDA();
        if (jda != null) {
            return SafeTextChannelReference.of(jda.getTextChannelById(channelID));
        }
        return null;
    }

    public static void SetActivity(ActivityType type, String text, String extra) {
        JDA jda = JDAUtil.getJDA();
        if (jda != null) {
            switch (type) {
                case LISTENING: {
                    jda.getPresence().setActivity(Activity.listening((String)text));
                    break;
                }
                case PLAYING: {
                    jda.getPresence().setActivity(Activity.playing((String)text));
                    break;
                }
                case WATCHING: {
                    jda.getPresence().setActivity(Activity.watching((String)text));
                    break;
                }
                case COMPETING: {
                    jda.getPresence().setActivity(Activity.competing((String)text));
                    break;
                }
                case STREAMING: {
                    jda.getPresence().setActivity(Activity.streaming((String)text, (String)extra));
                    break;
                }
            }
        }
    }

    public static enum ActivityType {
        DISABLED,
        LISTENING,
        PLAYING,
        WATCHING,
        COMPETING,
        STREAMING;

    }
}

