/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.api.jda.listeners;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeUserReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafeMessageChannelReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafeTextChannelReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.messages.SafeMessageReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;

public abstract class SafeMultiChannelListener
extends ListenerAdapter {
    private static final List<Supplier<String>> ignoreChannels = new ArrayList<Supplier<String>>();

    public static void ignoreChannel(Supplier<String> channel) {
        if (!ignoreChannels.contains(channel)) {
            ignoreChannels.add(channel);
        }
    }

    public static void allowChannel(Supplier<String> channel) {
        ignoreChannels.remove(channel);
    }

    public static List<String> convertListType(List<? extends String> list) {
        return new ArrayList<String>(list);
    }

    public static List<String> getIgnoredChannels() {
        ArrayList<String> list = new ArrayList<String>();
        for (Supplier<String> ignoreSource : ignoreChannels) {
            String value = (String)ignoreSource.get();
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static boolean canListenToChannel(List<? extends String> blacklistConfig, String channelID) {
        List<String> blacklist = SafeMultiChannelListener.convertListType(blacklistConfig);
        blacklist.addAll(SafeMultiChannelListener.getIgnoredChannels());
        return SafeMultiChannelListener.canListenToChannelInternal(blacklist, channelID);
    }

    public static boolean canListenToChannel(String channelID) {
        return SafeMultiChannelListener.canListenToChannelInternal(SafeMultiChannelListener.getIgnoredChannels(), channelID);
    }

    private static boolean canListenToChannelInternal(List<String> blacklist, String channelID) {
        for (String channel : blacklist) {
            if (!channel.equals(channelID)) continue;
            return false;
        }
        return true;
    }

    public final void onMessageReceived(@Nonnull MessageReceivedEvent event) {
        if (SafeMultiChannelListener.canListenToChannel(event.getChannel().getId())) {
            SafeMessageReference message = SafeMessageReference.of(event.getMessage());
            if (event.isFromGuild()) {
                SafeTextChannelReference channel = SafeTextChannelReference.of(event.getChannel());
                SafeMemberReference user = SafeMemberReference.of(event.getMember());
                this.OnMessage(channel, user, message, MessageType.GUILD);
            } else {
                SafeMessageChannelReference channel = SafeMessageChannelReference.of((MessageChannel)event.getChannel());
                SafeUserReference user = SafeUserReference.of(event.getAuthor());
                this.OnMessage(channel, user, message, event.getChannel().getType() == ChannelType.PRIVATE ? MessageType.PRIVATE : MessageType.UNKNOWN);
            }
        }
    }

    protected abstract void OnMessage(SafeMessageChannelReference var1, SafeUserReference var2, SafeMessageReference var3, MessageType var4);

    protected static enum MessageType {
        UNKNOWN,
        GUILD,
        PRIVATE;

    }
}

