/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.api.jda.listeners;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmansdiscord.api.jda.JDAUtil;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeGuildReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeUserReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafePrivateChannelReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafeTextChannelReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.messages.SafeMessageReference;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.PrivateChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;

public abstract class SafeSingleChannelListener
extends ListenerAdapter {
    private final Supplier<String> channelID;

    protected boolean listenToPrivateMessages() {
        return false;
    }

    protected SafeSingleChannelListener(@Nonnull Supplier<String> channelID) {
        this.channelID = channelID;
    }

    @Nullable
    public final SafeTextChannelReference getChannel() {
        return JDAUtil.getTextChannel((String)this.channelID.get());
    }

    public final void sendMessage(String message) {
        SafeTextChannelReference channel = this.getChannel();
        if (channel != null) {
            channel.sendMessage(message);
        }
    }

    public final void sendMessage(List<String> message) {
        SafeTextChannelReference channel = this.getChannel();
        if (channel != null) {
            channel.sendMessage(message);
        }
    }

    public final void setTopic(String topic) {
        SafeTextChannelReference channel = this.getChannel();
        if (channel != null) {
            channel.setTopic(topic);
        }
    }

    public final String getTopic() {
        SafeTextChannelReference channel = this.getChannel();
        if (channel != null) {
            return channel.getTopic();
        }
        return "";
    }

    @Nullable
    public final SafeGuildReference getGuild() {
        SafeTextChannelReference channel = this.getChannel();
        if (channel != null) {
            return channel.getGuild();
        }
        return null;
    }

    private boolean isCorrectChannel(MessageChannelUnion channel) {
        return Objects.equals(channel.getId(), this.channelID.get());
    }

    public final void onMessageReceived(@Nonnull MessageReceivedEvent event) {
        SafeMemberReference member;
        SafeGuildReference guild;
        MessageChannelUnion messageChannelUnion;
        if (this.listenToPrivateMessages() && (messageChannelUnion = event.getChannel()) instanceof PrivateChannel) {
            PrivateChannel pc = (PrivateChannel)messageChannelUnion;
            SafePrivateChannelReference channel = SafePrivateChannelReference.of(pc);
            SafeUserReference user = SafeUserReference.of(event.getAuthor());
            SafeMessageReference message = SafeMessageReference.of(event.getMessage());
            this.OnPrivateMessage(channel, user, message);
        }
        if (this.isCorrectChannel(event.getChannel()) && event.getChannel().getType() == ChannelType.TEXT && (guild = this.getGuild()) != null && (member = SafeMemberReference.of(event.getMember())) != null) {
            this.OnTextChannelMessage(member, SafeMessageReference.of(event.getMessage()));
        }
    }

    protected abstract void OnTextChannelMessage(SafeMemberReference var1, SafeMessageReference var2);

    protected void OnPrivateMessage(SafePrivateChannelReference channel, SafeUserReference user, SafeMessageReference message) {
    }
}

