/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmansdiscord.discord.links.AccountManager;
import io.github.lightman314.lightmansdiscord.discord.links.LinkedAccount;
import io.github.lightman314.lightmansdiscord.message.MessageManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandDiscordLink {
    public static final String COMMAND_LITERAL = "linkdiscord";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder discordLinkCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_LITERAL).requires(commandSource -> commandSource.m_81373_() instanceof Player)).then(Commands.m_82129_((String)"linkkey", (ArgumentType)MessageArgument.m_96832_()).executes(CommandDiscordLink::linkPlayer));
        dispatcher.register(discordLinkCommand);
    }

    static int linkPlayer(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        String linkKey = MessageArgument.m_96835_(commandContext, (String)"linkkey").getString();
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer player = source.m_81375_();
        int output = AccountManager.tryLinkUser((Player)player, linkKey);
        if (output == 1) {
            String discordName = "ERROR";
            LinkedAccount account = AccountManager.getLinkedAccountFromPlayer((Player)player);
            if (account != null) {
                discordName = account.getMemberName();
            }
            source.m_81354_((Component)MessageManager.M_COMMAND_LINK_COMPLETE.formatComponent(discordName), true);
            return 1;
        }
        if (output == 0) {
            source.m_81352_((Component)MessageManager.M_COMMAND_LINK_BADKEY.formatComponent(linkKey));
            return 0;
        }
        if (output == -1) {
            String discordName = "ERROR";
            LinkedAccount account = AccountManager.getLinkedAccountFromPlayer((Player)player);
            if (account != null) {
                discordName = account.getMemberName();
            }
            source.m_81352_((Component)MessageManager.M_COMMAND_LINK_ALREADYLINKED.formatComponent(discordName));
            return 0;
        }
        return 0;
    }
}

