/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerVisibilityUtil {
    private static final List<Function<Player, Boolean>> playerListFilters = new ArrayList<Function<Player, Boolean>>();

    public static void addPlayerHideFilter(Function<Player, Boolean> filter) {
        playerListFilters.add(Objects.requireNonNull(filter));
    }

    public static boolean isPlayerVisible(Player player) {
        for (Function<Player, Boolean> f : playerListFilters) {
            if (!f.apply(player).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static List<ServerPlayer> getPlayerList() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        List players = server == null ? new ArrayList() : server.m_6846_().m_11314_();
        return players.stream().filter(PlayerVisibilityUtil::isPlayerVisible).collect(Collectors.toList());
    }
}

