/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.discord.links;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmansdiscord.LightmansDiscordIntegration;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeUserReference;
import io.github.lightman314.lightmansdiscord.discord.links.LinkedAccount;
import io.github.lightman314.lightmansdiscord.discord.links.PendingLink;
import io.github.lightman314.lightmansdiscord.message.MessageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class AccountManager
extends SavedData {
    private static final String DATA_NAME = "lightmansconsole_linked_accounts";
    List<PendingLink> pendingLinks = new ArrayList<PendingLink>();
    List<LinkedAccount> linkedAccounts = new ArrayList<LinkedAccount>();
    List<String> currencyNotifications = new ArrayList<String>();

    public static List<PendingLink> getPendingLinks() {
        return AccountManager.get().pendingLinks;
    }

    public static List<LinkedAccount> getLinkedAccounts() {
        return AccountManager.get().linkedAccounts;
    }

    public AccountManager() {
    }

    public AccountManager(CompoundTag compound) {
        Object id;
        CompoundTag thisCompound;
        int i;
        if (compound.m_128425_("LinkedAccounts", 9)) {
            this.linkedAccounts.clear();
            ListTag accountList = compound.m_128437_("LinkedAccounts", 10);
            for (i = 0; i < accountList.size(); ++i) {
                thisCompound = accountList.m_128728_(i);
                id = thisCompound.m_128342_("id");
                String discordID = thisCompound.m_128461_("discord");
                this.linkedAccounts.add(new LinkedAccount((UUID)id, discordID));
            }
        }
        if (compound.m_128425_("PendingLinks", 9)) {
            this.pendingLinks.clear();
            ListTag pendingLinkList = compound.m_128437_("PendingLinks", 10);
            for (i = 0; i < pendingLinkList.size(); ++i) {
                thisCompound = pendingLinkList.m_128728_(i);
                id = thisCompound.m_128461_("id");
                String linkKey = thisCompound.m_128461_("key");
                this.pendingLinks.add(new PendingLink(linkKey, (String)id));
            }
        }
        if (compound.m_128425_("CurrencyNotifications", 9)) {
            this.currencyNotifications.clear();
            ListTag currencyNotificationList = compound.m_128437_("CurrencyNotifications", 10);
            for (i = 0; i < currencyNotificationList.size(); ++i) {
                thisCompound = currencyNotificationList.m_128728_(i);
                this.currencyNotifications.add(thisCompound.m_128461_("id"));
            }
        }
        if (compound.m_128425_("PartialLinks", 9)) {
            ListTag partialLinkList = compound.m_128437_("PartialLinks", 10);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            for (int i2 = 0; i2 < partialLinkList.size(); ++i2) {
                CompoundTag thisCompound2 = partialLinkList.m_128728_(i2);
                String name = thisCompound2.m_128461_("name");
                String id2 = thisCompound2.m_128461_("id");
                GameProfile profile = server.m_129927_().m_10996_(name).orElse(null);
                if (profile == null) continue;
                LinkedAccount newLink = new LinkedAccount(profile.getId(), id2);
                if (this.getAccountFromPlayerID(profile.getId()) != null || this.getAccountFromDiscordID(id2) != null) continue;
                this.linkedAccounts.add(newLink);
            }
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        ListTag accountList = new ListTag();
        for (LinkedAccount linkedAccount : this.linkedAccounts) {
            CompoundTag thisCompound = new CompoundTag();
            thisCompound.m_128362_("id", linkedAccount.playerID);
            thisCompound.m_128359_("discord", linkedAccount.discordID);
            accountList.add((Object)thisCompound);
        }
        compound.m_128365_("LinkedAccounts", (Tag)accountList);
        ListTag pendingLinkList = new ListTag();
        for (PendingLink thisLink : this.pendingLinks) {
            CompoundTag thisCompound = new CompoundTag();
            thisCompound.m_128359_("id", thisLink.userID);
            thisCompound.m_128359_("key", thisLink.linkKey);
            pendingLinkList.add((Object)thisCompound);
        }
        compound.m_128365_("PendingLinks", (Tag)pendingLinkList);
        ListTag listTag = new ListTag();
        for (String currencyNotification : this.currencyNotifications) {
            CompoundTag thisCompound = new CompoundTag();
            thisCompound.m_128359_("id", currencyNotification);
            listTag.add((Object)thisCompound);
        }
        compound.m_128365_("CurrencyNotifications", (Tag)listTag);
        return compound;
    }

    private LinkedAccount getAccountFromMinecraftName(String name) {
        for (LinkedAccount linkedAccount : this.linkedAccounts) {
            if (!linkedAccount.equalsPlayerName(name)) continue;
            return linkedAccount;
        }
        return null;
    }

    public static LinkedAccount getLinkedAccountFromMinecraftName(String name) {
        return AccountManager.get().getAccountFromMinecraftName(name);
    }

    private LinkedAccount getAccountFromDiscordID(String discordID) {
        for (LinkedAccount linkedAccount : this.linkedAccounts) {
            if (!linkedAccount.equalsDiscordID(discordID)) continue;
            return linkedAccount;
        }
        return null;
    }

    public static LinkedAccount getLinkedAccountFromDiscordID(String discordID) {
        return AccountManager.get().getAccountFromDiscordID(discordID);
    }

    @Deprecated(since="0.2.0.0")
    public static LinkedAccount getLinkedAccountFromUser(User user) {
        return AccountManager.getLinkedAccountFromDiscordID(user.getId());
    }

    public static LinkedAccount getLinkedAccountFromUser(SafeUserReference user) {
        return AccountManager.getLinkedAccountFromDiscordID(user.getID());
    }

    @Deprecated(since="0.2.0.0")
    public static LinkedAccount getLinkedAccountFromMember(Member member) {
        return AccountManager.getLinkedAccountFromUser(member.getUser());
    }

    public static LinkedAccount getLinkedAccountFromMember(SafeMemberReference member) {
        return AccountManager.getLinkedAccountFromUser(member);
    }

    private LinkedAccount getAccountFromPlayer(Player player) {
        for (LinkedAccount linkedAccount : this.linkedAccounts) {
            if (!linkedAccount.equalsPlayer(player)) continue;
            return linkedAccount;
        }
        return null;
    }

    public static LinkedAccount getLinkedAccountFromPlayer(Player player) {
        return AccountManager.get().getAccountFromPlayer(player);
    }

    private LinkedAccount getAccountFromPlayerID(UUID playerID) {
        for (LinkedAccount linkedAccount : this.linkedAccounts) {
            if (!linkedAccount.playerID.equals(playerID)) continue;
            return linkedAccount;
        }
        return null;
    }

    public static LinkedAccount getLinkedAccountFromPlayerID(UUID playerID) {
        return AccountManager.get().getAccountFromPlayerID(playerID);
    }

    private void removeLinkedAccount(LinkedAccount account) {
        if (this.linkedAccounts.contains(account)) {
            this.linkedAccounts.remove(account);
            this.m_77762_();
        }
    }

    private PendingLink getPendingLinkFromUser(User user) {
        for (PendingLink pendingLink : this.pendingLinks) {
            if (!pendingLink.userID.equals(user.getId())) continue;
            return pendingLink;
        }
        return null;
    }

    private PendingLink getPendingLinkFromKey(String linkKey) {
        for (PendingLink pendingLink : this.pendingLinks) {
            if (!pendingLink.linkKey.equals(linkKey)) continue;
            return pendingLink;
        }
        return null;
    }

    private void removePendingLink(PendingLink link) {
        if (this.pendingLinks.contains(link)) {
            this.pendingLinks.remove(link);
            this.m_77762_();
        }
    }

    private static AccountManager get() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerLevel world = server.m_129783_();
        return (AccountManager)world.m_8895_().m_164861_(AccountManager::new, AccountManager::new, DATA_NAME);
    }

    public static PendingLink createPendingLink(User user) {
        AccountManager manager = AccountManager.get();
        if (manager.getAccountFromDiscordID(user.getId()) != null) {
            return null;
        }
        PendingLink link = manager.getPendingLinkFromUser(user);
        if (link != null) {
            return link;
        }
        link = new PendingLink(user.getId());
        manager.pendingLinks.add(link);
        manager.m_77762_();
        return link;
    }

    public static void unlinkAccount(LinkedAccount account) {
        AccountManager manager = AccountManager.get();
        manager.removeLinkedAccount(account);
        manager.m_77762_();
    }

    public static int tryLinkUser(Player player, String linkKey) {
        AccountManager manager = AccountManager.get();
        PendingLink pendingLink = manager.getPendingLinkFromKey(linkKey);
        if (pendingLink == null) {
            return 0;
        }
        if (manager.getAccountFromPlayer(player) != null) {
            return -1;
        }
        LinkedAccount newAccount = new LinkedAccount(player.m_142081_(), pendingLink.userID);
        manager.removePendingLink(pendingLink);
        manager.linkedAccounts.add(newAccount);
        return 1;
    }

    public static List<String> tryUnlinkUser(User user) {
        String discordID;
        AccountManager manager = AccountManager.get();
        LinkedAccount account = manager.getAccountFromDiscordID(discordID = user.getId());
        if (account != null) {
            manager.removeLinkedAccount(account);
            return ImmutableList.of((Object)MessageManager.M_UNLINK_SUCCESS.format(account.getName()));
        }
        PendingLink pendingLink = manager.getPendingLinkFromUser(user);
        if (pendingLink != null) {
            manager.removePendingLink(pendingLink);
            return ImmutableList.of((Object)MessageManager.M_UNLINK_PENDING.get());
        }
        return ImmutableList.of((Object)MessageManager.M_UNLINK_FAIL.get());
    }

    public static List<String> tryForceUnlinkUser(String playerName) {
        AccountManager manager = AccountManager.get();
        LinkedAccount account = manager.getAccountFromMinecraftName(playerName);
        if (account != null) {
            manager.removeLinkedAccount(account);
            return ImmutableList.of((Object)MessageManager.M_UNLINKPLAYER_SUCCESS.format(account.getName(), account.getMemberName()));
        }
        return ImmutableList.of((Object)MessageManager.M_UNLINKPLAYER_FAIL.format(playerName));
    }

    public static List<String> tryLinkUser2(User user, String playerName) {
        AccountManager manager = AccountManager.get();
        if (manager.getAccountFromMinecraftName(playerName) != null) {
            return ImmutableList.of((Object)MessageManager.M_LINKUSER_PLAYERLINKED.format(playerName));
        }
        if (manager.getAccountFromDiscordID(user.getId()) != null) {
            return ImmutableList.of((Object)MessageManager.M_LINKUSER_USERLINKED.format(user.getName(), manager.getAccountFromDiscordID(user.getId()).getName()));
        }
        if (manager.getPendingLinkFromUser(user) != null) {
            return ImmutableList.of((Object)MessageManager.M_LINKUSER_USERPENDING.format(user.getName()));
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        GameProfile playerProfile = server.m_129927_().m_10996_(playerName).orElse(null);
        if (playerProfile != null) {
            LinkedAccount newAccount = new LinkedAccount(playerProfile.getId(), user.getId());
            manager.linkedAccounts.add(newAccount);
            manager.m_77762_();
            LightmansDiscordIntegration.LOGGER.info("Linked discord #" + user.getId() + " with '" + playerProfile.getName() + "' (" + playerProfile.getId().toString() + ")");
            return ImmutableList.of((Object)MessageManager.M_LINKUSER_SUCCESS.format(user.getName(), newAccount.getName()));
        }
        return ImmutableList.of((Object)MessageManager.M_LINKUSER_NO_ACCOUNT.format(playerName));
    }

    public static boolean currencyNotificationsEnabled(User user) {
        if (user == null) {
            return false;
        }
        return AccountManager.get().currencyNotifications.contains(user.getId());
    }

    public static boolean enableCurrencyNotifications(User user) {
        List<String> currencyNotifications = AccountManager.get().currencyNotifications;
        if (!currencyNotifications.contains(user.getId())) {
            currencyNotifications.add(user.getId());
            AccountManager.get().m_77762_();
            return true;
        }
        return false;
    }

    public static boolean disableCurrencyNotifications(User user) {
        List<String> currencyNotifications = AccountManager.get().currencyNotifications;
        if (currencyNotifications.contains(user.getId())) {
            currencyNotifications.remove(user.getId());
            AccountManager.get().m_77762_();
            return true;
        }
        return false;
    }
}

