/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.discord.listeners.account;

import io.github.lightman314.lightmansdiscord.LDIConfig;
import io.github.lightman314.lightmansdiscord.LightmansDiscordIntegration;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeRoleReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeUserReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafeMessageChannelReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafeTextChannelReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.messages.SafeMessageReference;
import io.github.lightman314.lightmansdiscord.api.jda.listeners.SafeMultiChannelListener;
import io.github.lightman314.lightmansdiscord.discord.links.AccountManager;
import io.github.lightman314.lightmansdiscord.discord.links.LinkedAccount;
import io.github.lightman314.lightmansdiscord.discord.links.PendingLink;
import io.github.lightman314.lightmansdiscord.discord.listeners.account.AccountCommand;
import io.github.lightman314.lightmansdiscord.message.MessageManager;
import io.github.lightman314.lightmansdiscord.util.MemberUtil;
import io.github.lightman314.lightmansdiscord.util.MessageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class AccountMessageListener
extends SafeMultiChannelListener
implements CommandSource {
    private final List<AccountCommand> REGISTERED_COMMANDS = new ArrayList<AccountCommand>();
    private final List<String> commandOutput = new ArrayList<String>();
    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();

    public AccountMessageListener() {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterAccountCommandEvent(this));
    }

    @Override
    protected void OnMessage(SafeMessageChannelReference channel, SafeUserReference user, SafeMessageReference message, SafeMultiChannelListener.MessageType type) {
        if (user == null || user.isBot() || type != SafeMultiChannelListener.MessageType.GUILD || !(channel instanceof SafeTextChannelReference)) {
            return;
        }
        SafeTextChannelReference textchannel = (SafeTextChannelReference)channel;
        boolean isAdmin = AccountMessageListener.isAdmin(user);
        String input = message.getRaw();
        String prefix = (String)LDIConfig.SERVER.accountCommandPrefix.get();
        if (input.startsWith(prefix)) {
            String command = input.substring(prefix.length());
            if (command.startsWith("linkuser")) {
                if (!isAdmin) {
                    textchannel.sendMessage(MessageManager.M_ERROR_PERMISSIONS.get());
                    return;
                }
                String subcommand = command.substring(8);
                LightmansDiscordIntegration.LOGGER.info(command + " -> " + subcommand);
                SafeMemberReference linkingUser = MemberUtil.getMemberFromPing(textchannel.getGuild(), subcommand);
                int endIndex = subcommand.indexOf(62);
                if (endIndex < 0) {
                    textchannel.sendMessage(MessageManager.M_ERROR_NOPING.get());
                    return;
                }
                String playerName = subcommand.substring(endIndex + 1).replace(" ", "");
                if (linkingUser != null) {
                    ArrayList<String> output = new ArrayList<String>();
                    try {
                        output.addAll(AccountManager.tryLinkUser2(linkingUser.getUser(), playerName));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (((Boolean)LDIConfig.SERVER.accountWhitelist.get()).booleanValue()) {
                        try {
                            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                            server.m_129892_().m_82117_(this.getCommandSource(), "whitelist add " + playerName);
                            output.addAll(this.commandOutput);
                            this.commandOutput.clear();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    textchannel.sendMessage(output);
                    MessageUtil.sendPrivateMessage(linkingUser.getUser(), MessageManager.M_LINKUSER_WELCOME.get());
                } else {
                    textchannel.sendMessage(MessageManager.M_ERROR_PING.get());
                }
            } else if (command.startsWith("unlinkplayer ")) {
                if (!isAdmin) {
                    textchannel.sendMessage(MessageManager.M_ERROR_PERMISSIONS.get());
                    return;
                }
                String playerName = command.substring(13);
                List<String> output = AccountManager.tryForceUnlinkUser(playerName);
                textchannel.sendMessage(output);
            } else if (command.startsWith("link")) {
                PendingLink pendingLink = AccountManager.createPendingLink(user.getUser());
                if (pendingLink == null) {
                    textchannel.sendMessage(MessageManager.M_LINK_FAIL.get());
                } else {
                    textchannel.sendMessage(MessageManager.M_LINK_SUCCESS.get());
                    user.sendPrivateMessage(MessageManager.M_LINK_MESSAGE.format(pendingLink.linkKey, "/linkdiscord " + pendingLink.linkKey));
                }
            } else if (command.startsWith("unlink")) {
                textchannel.sendMessage(AccountManager.tryUnlinkUser(user.getUser()));
            } else if (command.startsWith("discordlist")) {
                if (!isAdmin) {
                    textchannel.sendMessage(MessageManager.M_ERROR_PERMISSIONS.get());
                    return;
                }
                ArrayList<String> output = new ArrayList<String>();
                output.add("------**Linked Accounts**------");
                AccountManager.getLinkedAccounts().forEach(la -> {
                    output.add("DiscordID: " + la.discordID);
                    SafeMemberReference member = textchannel.getGuild().getMember(la.discordID);
                    if (member != null) {
                        output.add("Discord Name: " + member.getEffectiveName());
                    }
                    output.add("Minecraft ID: " + la.playerID.toString());
                    output.add("Minecraft Name: " + la.getName());
                    output.add("");
                });
                output.add("------**Pending Links**------");
                AccountManager.getPendingLinks().forEach(pl -> {
                    output.add("DiscordID: " + pl.userID);
                    SafeMemberReference member = textchannel.getGuild().getMember(pl.userID);
                    if (member != null) {
                        output.add("Discord Name: " + member.getEffectiveName());
                    }
                    output.add("Link Key: " + pl.linkKey);
                });
                textchannel.sendMessage(output);
            } else if (command.startsWith("help")) {
                String commandPrefix = (String)LDIConfig.SERVER.accountCommandPrefix.get();
                ArrayList<String> output = new ArrayList<String>();
                output.add("Minecraft-Discord Account Linkage Help:");
                output.add(commandPrefix + "help - " + MessageManager.M_HELP_HELP.get());
                output.add(commandPrefix + "link - " + MessageManager.M_HELP_LINK.get());
                output.add(commandPrefix + "unlink - " + MessageManager.M_HELP_UNLINK.get());
                if (isAdmin) {
                    output.add(commandPrefix + "linkuser @user <MINECRAFT_USERNAME> - " + MessageManager.M_HELP_LINKUSER.get());
                    output.add(commandPrefix + "unlinkplayer <MINECRAFT_USERNAME> - " + MessageManager.M_HELP_UNLINKPLAYER.get());
                    output.add(commandPrefix + "discordlist - " + MessageManager.M_HELP_DISCORDLIST.get());
                }
                this.REGISTERED_COMMANDS.forEach(c -> {
                    if (c.canRun(isAdmin)) {
                        c.addToHelpText(output, commandPrefix);
                    }
                });
                textchannel.sendMessage(output);
            } else {
                ArrayList<String> output = new ArrayList<String>();
                LinkedAccount account = AccountManager.getLinkedAccountFromUser(user);
                this.REGISTERED_COMMANDS.forEach(c -> {
                    if (command.startsWith(c.literal) && c.canRun(isAdmin)) {
                        try {
                            c.safeRunCommand(command, account, textchannel.getGuild(), output);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                textchannel.sendMessage(output);
            }
        }
    }

    public static boolean isAdmin(SafeUserReference user) {
        if (user == null) {
            return false;
        }
        if (user instanceof SafeMemberReference) {
            SafeMemberReference member = (SafeMemberReference)user;
            List<SafeRoleReference> roles = member.getRoles();
            for (SafeRoleReference role : roles) {
                if (!((List)LDIConfig.SERVER.accountAdminRole.get()).contains(role.getID())) continue;
                return true;
            }
        }
        return false;
    }

    private CommandSourceStack getCommandSource() {
        ServerLevel level = this.server.m_129783_();
        return new CommandSourceStack((CommandSource)this, Vec3.m_82539_((Vec3i)level.m_8900_()), Vec2.f_82462_, level, 4, "AccountBot", (Component)new TextComponent("AccountBot"), this.server, null);
    }

    public void registerCommand(AccountCommand command) {
        if (!this.REGISTERED_COMMANDS.contains(command)) {
            this.REGISTERED_COMMANDS.add(command);
        }
    }

    public boolean m_6102_() {
        return true;
    }

    public boolean m_7028_() {
        return true;
    }

    public boolean m_6999_() {
        return true;
    }

    public void m_6352_(Component component, @Nonnull UUID id) {
        this.commandOutput.add(component.getString());
    }

    public static class RegisterAccountCommandEvent
    extends Event {
        private final AccountMessageListener listener;

        public RegisterAccountCommandEvent(AccountMessageListener listener) {
            this.listener = listener;
        }

        public void registerCommand(AccountCommand command) {
            this.listener.registerCommand(command);
        }
    }
}

