/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.discord.listeners.account.commands;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeGuildReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.discord.links.AccountManager;
import io.github.lightman314.lightmansdiscord.discord.links.LinkedAccount;
import io.github.lightman314.lightmansdiscord.discord.listeners.account.AccountCommand;
import io.github.lightman314.lightmansdiscord.util.MemberUtil;
import io.github.lightman314.lightmansdiscord.util.PlayerUtil;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class StatsCommand
extends AccountCommand {
    private static List<Stat<?>> ALL_STATS = null;

    public StatsCommand() {
        super("stats", false, false);
    }

    @Override
    public void addToHelpText(List<String> output, String prefix) {
        output.add(prefix + this.literal + " @discorduser [statFilter] - Get another users minecraft stats.");
        output.add(prefix + this.literal + " [statFilter] - Get your minecraft stats.");
    }

    @Override
    public void runCommand(String commandInput, LinkedAccount account, SafeGuildReference guild, List<String> output) {
        if (commandInput.length() > this.literal.length()) {
            String commandContext = commandInput.substring(this.literal.length() + 1);
            if (commandContext.startsWith("<@")) {
                SafeMemberReference member = MemberUtil.getMemberFromPing(guild, commandContext);
                if (member != null) {
                    LinkedAccount a = AccountManager.getLinkedAccountFromMember(member);
                    if (a != null) {
                        String type = commandContext.substring(commandContext.indexOf(62) + 2).toLowerCase();
                        this.getStatsForPlayerID(a.playerID, type, output);
                    } else {
                        output.add(this.accountNotLinkedErrorForMember(member));
                    }
                } else {
                    output.add(this.cannotGetUserFromPingError());
                }
            } else if (account != null) {
                this.getStatsForPlayerID(account.playerID, commandContext.toLowerCase(), output);
            } else {
                output.add(this.accountNotLinkedErrorSelf());
            }
        } else if (account != null) {
            this.getStatsForPlayerID(account.playerID, "", output);
        } else {
            output.add(this.accountNotLinkedErrorSelf());
        }
    }

    private void getStatsForPlayerID(UUID playerId, String type, List<String> output) {
        int outputStartLength = output.size();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        GameProfile profile = PlayerUtil.playerProfile(playerId);
        if (profile != null && server != null) {
            FakePlayer fakePlayer = new FakePlayer(server.m_129783_(), profile);
            fakePlayer.m_142687_(Entity.RemovalReason.DISCARDED);
            ServerStatsCounter statsManager = server.m_6846_().m_11239_((Player)fakePlayer);
            AtomicReference<String> typeName = new AtomicReference<String>(type.toLowerCase());
            this.getAllStats().forEach(thisStat -> {
                int value;
                if (thisStat.m_83620_().toLowerCase().contains((CharSequence)typeName.get()) && (value = statsManager.m_13015_(thisStat)) > 0) {
                    output.add(thisStat.m_83620_() + ": " + value);
                }
            });
        } else {
            output.add("**ERROR**: Could not get game profile of the linked user!");
        }
        if (output.size() == outputStartLength) {
            if (profile == null) {
                output.add("Could not find player profile for the given player.");
            } else {
                String error = "No results found for " + profile.getName();
                if (!type.isEmpty()) {
                    error = error + " for query '" + type + "'";
                }
                output.add(error);
            }
        }
    }

    private List<Stat<?>> getAllStats() {
        if (ALL_STATS == null) {
            ALL_STATS = Lists.newArrayList();
            ForgeRegistries.STAT_TYPES.forEach(statType -> statType.forEach(stat -> ALL_STATS.add((Stat<?>)stat)));
        }
        return ALL_STATS;
    }
}

