/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.discord.listeners.chat;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmansdiscord.LDIConfig;
import io.github.lightman314.lightmansdiscord.LightmansDiscordIntegration;
import io.github.lightman314.lightmansdiscord.api.jda.JDAUtil;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.messages.SafeMessageReference;
import io.github.lightman314.lightmansdiscord.api.jda.listeners.SafeSingleChannelListener;
import io.github.lightman314.lightmansdiscord.compat.PlayerVisibilityUtil;
import io.github.lightman314.lightmansdiscord.message.MessageEntry;
import io.github.lightman314.lightmansdiscord.message.MessageManager;
import io.github.lightman314.lightmansdiscord.util.MessageUtil;
import io.github.lightman314.lightmansdiscord.util.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ChatMessageListener
extends SafeSingleChannelListener {
    private static final UUID SYSTEM_ID = new UUID(0L, 0L);
    private static ChatMessageListener instance = null;
    private final MinecraftServer server;

    public ChatMessageListener(Supplier<String> channelID) {
        super(channelID);
        instance = this;
        this.server = ServerLifecycleHooks.getCurrentServer();
        this.sendMessage(MessageManager.M_SERVER_BOOT.get());
        this.setTopic(MessageManager.M_TOPIC_BOOT.get());
        this.setActivityText(MessageManager.M_ACTIVITY_BOOT.get());
    }

    @Override
    protected void OnTextChannelMessage(SafeMemberReference member, SafeMessageReference message) {
        if (member == null) {
            return;
        }
        if (member.isBot()) {
            if (((List)LDIConfig.SERVER.chatBotWhitelist.get()).contains(member.getID())) {
                Component output = this.formatDiscordMessage(MessageManager.M_FORMAT_MINECRAFT_BOT, member, message, "bot");
                this.server.m_6846_().m_11314_().forEach(player -> player.m_6352_(output, SYSTEM_ID));
                LightmansDiscordIntegration.LOGGER.info(output.getString());
            }
            return;
        }
        if (message.getRaw().equals(LDIConfig.SERVER.listPlayerCommand.get())) {
            ArrayList<String> output = new ArrayList<String>();
            List<ServerPlayer> playerList = PlayerVisibilityUtil.getPlayerList();
            String intro = MessageManager.M_PLAYER_LIST.format(playerList.size());
            if (intro.length() > 0) {
                output.add(intro);
            }
            StringBuilder playerText = new StringBuilder();
            for (ServerPlayer player2 : playerList) {
                if (playerText.length() > 0) {
                    playerText.append(", ");
                }
                playerText.append(PlayerUtil.playerName((Entity)player2));
            }
            if (playerText.length() > 0) {
                output.add(playerText.toString());
            }
            this.sendMessage(output);
            return;
        }
        Component output = this.formatDiscordMessage(MessageManager.M_FORMAT_MINECRAFT, member, message, "user");
        this.server.m_6846_().m_11314_().forEach(player -> player.m_6352_(output, SYSTEM_ID));
        LightmansDiscordIntegration.LOGGER.info(output.getString());
    }

    public void updatePlayerCount() {
        this.updatePlayerCount(false);
    }

    public void updatePlayerCount(boolean shrink) {
        int playerCount = this.getPlayerCount(shrink);
        this.setTopic(MessageManager.M_TOPIC_TEXT.format(playerCount));
        this.setActivityText(MessageManager.M_ACTIVITY_TEXT.format(playerCount, this.getPlayerLimit()));
    }

    public final void setActivityText(String text) {
        JDAUtil.SetActivity((JDAUtil.ActivityType)((Object)LDIConfig.SERVER.botActivityType.get()), text, (String)LDIConfig.SERVER.botStreamURL.get());
    }

    private int getPlayerCount(boolean shrink) {
        return shrink ? this.getPlayerCount() - 1 : this.getPlayerCount();
    }

    private int getPlayerLimit() {
        return ServerLifecycleHooks.getCurrentServer().m_7418_();
    }

    private int getPlayerCount() {
        return PlayerVisibilityUtil.getPlayerList().size();
    }

    @SubscribeEvent
    public void onServerMessage(ServerChatEvent event) {
        try {
            String message = MessageManager.M_FORMAT_DISCORD.format(PlayerUtil.playerName((Entity)event.getPlayer()), MessageUtil.formatMinecraftMessage(event.getMessage(), this.getGuild()));
            this.sendMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (PlayerVisibilityUtil.isPlayerVisible(event.getPlayer())) {
            ChatMessageListener.fakePlayerJoin(event.getPlayer());
        }
    }

    public static void fakePlayerJoin(Player player) {
        try {
            if (instance != null) {
                String playerName = PlayerUtil.playerName((Entity)player);
                instance.sendMessage(MessageManager.M_PLAYER_JOIN.format(new TranslatableComponent("multiplayer.player.joined", new Object[]{playerName}), playerName));
                instance.updatePlayerCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (PlayerVisibilityUtil.isPlayerVisible(event.getPlayer())) {
            ChatMessageListener.fakePlayerLeave(event.getPlayer(), true);
        }
    }

    public static void fakePlayerLeave(Player player, boolean shrinkPlayerCount) {
        try {
            if (instance != null) {
                String playerName = PlayerUtil.playerName((Entity)player);
                instance.sendMessage(MessageManager.M_PLAYER_LEAVE.format(new TranslatableComponent("multiplayer.player.left", new Object[]{playerName}), playerName));
                instance.updatePlayerCount(shrinkPlayerCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        try {
            if (event.getEntity() instanceof Player) {
                this.sendMessage(MessageManager.M_PLAYER_DEATH.format(event.getSource().m_6157_(event.getEntityLiving()), PlayerUtil.playerName(event.getEntity())));
            } else if (event.getEntity().m_8077_() && ((Boolean)LDIConfig.SERVER.postEntityDeaths.get()).booleanValue()) {
                this.sendMessage(MessageManager.M_ENTITY_DEATH.format(event.getSource().m_6157_(event.getEntityLiving()), PlayerUtil.playerName(event.getEntity())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onAchievementGet(AdvancementEvent ev) {
        try {
            if (ev.getAdvancement() != null && ev.getAdvancement().m_138320_() != null && ev.getAdvancement().m_138320_().m_14996_() && PlayerVisibilityUtil.isPlayerVisible(ev.getPlayer())) {
                this.sendMessage(MessageManager.M_PLAYER_ACHIEVEMENT.format(PlayerUtil.playerName(ev.getEntity()), ev.getAdvancement().m_138320_().m_14977_(), ev.getAdvancement().m_138320_().m_14985_()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerReady(ServerStartedEvent event) {
        try {
            this.sendMessage(MessageManager.M_SERVER_READY.get());
            this.updatePlayerCount();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        try {
            this.sendMessage(MessageManager.M_SERVER_STOP.get());
            this.setTopic(MessageManager.M_TOPIC_OFFLINE.get());
            this.setActivityText(MessageManager.M_ACTIVITY_OFFLINE.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isPresent() {
        return instance != null;
    }

    public static void sendChatMessage(String message) {
        if (instance != null) {
            instance.sendMessage(message);
        }
    }

    public Component formatDiscordMessage(MessageEntry format, SafeMemberReference member, SafeMessageReference message, String userFormat) {
        String[] splitMessage = format.format(MessageUtil.formatMessageText(message, this.getGuild())).split("\\{" + userFormat + "\\}");
        TextComponent result = new TextComponent(splitMessage[0]);
        for (int i = 1; i < splitMessage.length; ++i) {
            result.m_7220_(ChatMessageListener.formatMemberName(member));
            result.m_130946_(splitMessage[i]);
        }
        return result;
    }

    public static Component formatMemberName(SafeMemberReference member) {
        return new TextComponent(member.getEffectiveName()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)member.getColor())).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "<@!" + member.getID() + ">")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(MessageManager.M_MEMBER_HOVER.get()))));
    }
}

