/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.discord.listeners.console;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmansdiscord.LDIConfig;
import io.github.lightman314.lightmansdiscord.LightmansDiscordIntegration;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.messages.SafeMessageReference;
import io.github.lightman314.lightmansdiscord.api.jda.listeners.SafeSingleChannelListener;
import io.github.lightman314.lightmansdiscord.discord.listeners.console.ConsoleMode;
import io.github.lightman314.lightmansdiscord.message.MessageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ConsoleMessageListener
extends SafeSingleChannelListener
implements CommandSource {
    MinecraftServer server = null;
    List<String> output = new ArrayList<String>();

    protected final void checkForServer() {
        if (this.server == null) {
            this.server = ServerLifecycleHooks.getCurrentServer();
        }
    }

    public static ConsoleMode getMode() {
        return ConsoleMode.COMMANDS_ONLY;
    }

    public ConsoleMessageListener(Supplier<String> consoleChannel) {
        super(consoleChannel);
        if (ConsoleMessageListener.getMode().acceptCommands) {
            this.sendMessage(MessageManager.M_CONSOLEBOT_READY.get());
        }
        this.createLogAppender();
    }

    private void createLogAppender() {
    }

    @Override
    protected void OnTextChannelMessage(SafeMemberReference member, SafeMessageReference message) {
        String prefix;
        LightmansDiscordIntegration.LOGGER.debug("Received message '" + message.getRaw() + "' in console channel!\nCommand Prefix is '" + (String)LDIConfig.SERVER.consoleCommandPrefix.get() + "', and " + (message.getRaw().startsWith((String)LDIConfig.SERVER.consoleCommandPrefix.get()) ? "does" : "does not") + " match!");
        if (member == null || member.isBot()) {
            return;
        }
        if (!ConsoleMessageListener.getMode().acceptCommands) {
            return;
        }
        String command = message.getRaw();
        if (command.startsWith(prefix = (String)LDIConfig.SERVER.consoleCommandPrefix.get())) {
            if ((command = command.substring(prefix.length())).startsWith("mchelp")) {
                command = command.substring(2);
            }
            LightmansDiscordIntegration.LOGGER.info("Received Command: '" + command + "' from Discord!");
            this.checkForServer();
            if (this.server == null) {
                LightmansDiscordIntegration.LOGGER.error("Server is null!");
            } else {
                this.output.clear();
                this.server.m_129892_().m_82117_(this.getCommandSource(), command);
                this.sendMessage(this.output);
            }
        }
    }

    private CommandSourceStack getCommandSource() {
        ServerLevel world = this.server.m_129783_();
        return new CommandSourceStack((CommandSource)this, Vec3.m_82539_((Vec3i)world.m_8900_()), Vec2.f_82462_, world, 4, "ConsoleBot", (Component)new TextComponent("ConsoleBot"), this.server, null);
    }

    public void m_6352_(Component component, @Nonnull UUID id) {
        this.output.add(component.getString());
    }

    public boolean m_6999_() {
        return true;
    }

    public boolean m_7028_() {
        return true;
    }

    public boolean m_6102_() {
        return true;
    }
}

