/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.message;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class MessageEntry {
    public final String key;
    public final String comment;
    public final String defaultValue;
    private String currentValue;
    private final List<String> formatKeys;

    public void loadCurrentValue(@Nonnull String value) {
        this.currentValue = value;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public String get() {
        return this.format(new Object[0]);
    }

    public String format(Object ... format) {
        String result = this.currentValue;
        result = result.replace("\\n", "\n");
        for (int i = 0; i < this.formatKeys.size() && i < format.length; ++i) {
            String formatText = format[i].toString();
            if (format[i] instanceof Component) {
                formatText = ((Component)format[i]).getString();
            }
            result = result.replace("{" + this.formatKeys.get(i) + "}", formatText);
        }
        return result;
    }

    public MutableComponent getComponent() {
        return new TextComponent(this.get());
    }

    public MutableComponent formatComponent(Object ... format) {
        return new TextComponent(this.format(format));
    }

    protected MessageEntry(@Nonnull String key, @Nonnull String comment, @Nonnull String defaultValue, String ... formatKeys) {
        this.key = key;
        this.comment = comment;
        this.defaultValue = this.currentValue = defaultValue;
        this.formatKeys = Lists.newArrayList((Object[])formatKeys);
    }

    public static MessageEntry create(@Nonnull String key, @Nonnull String comment, @Nonnull String defaultValue, String ... formatKeys) {
        return new MessageEntry(key, comment, defaultValue, formatKeys);
    }

    public static MessageEntry create(@Nullable List<MessageEntry> list, @Nonnull String key, @Nonnull String comment, @Nonnull String defaultValue, String ... formatKeys) {
        return MessageEntry.create(list == null ? null : list::add, key, comment, defaultValue, formatKeys);
    }

    public static MessageEntry create(@Nullable Consumer<MessageEntry> consumer, @Nonnull String key, @Nonnull String comment, @Nonnull String defaultValue, String ... formatKeys) {
        MessageEntry entry = MessageEntry.create(key, comment, defaultValue, formatKeys);
        if (consumer != null) {
            consumer.accept(entry);
        }
        return entry;
    }

    @Nullable
    public static MessageEntry getEntry(@Nullable List<MessageEntry> list, @Nonnull String key) {
        if (list == null) {
            return null;
        }
        for (MessageEntry entry : list) {
            if (!entry.key.contentEquals(key)) continue;
            return entry;
        }
        return null;
    }
}

