/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.util;

import io.github.lightman314.lightmansdiscord.LightmansDiscordIntegration;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeGuildReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;

public class MemberUtil {
    public static String getUserIdFromPing(String pingText) {
        int startIndex = pingText.indexOf("<@");
        if (startIndex >= 0) {
            String ping = pingText.substring(startIndex);
            int endIndex = ping.indexOf(62);
            if (endIndex >= 0) {
                String id = ping.substring(2, endIndex);
                if (!"0123456789".contains(id.substring(0, 1))) {
                    id = id.substring(1);
                }
                LightmansDiscordIntegration.LOGGER.info("Extracted '" + id + "' from '" + pingText + "'");
                return id;
            }
            LightmansDiscordIntegration.LOGGER.warn("'" + pingText + "' has no '>'");
        } else {
            LightmansDiscordIntegration.LOGGER.warn("'" + pingText + "' does not start with '<@!'");
        }
        return "";
    }

    public static User getUserFromPing(JDA jda, String pingText) {
        User user;
        String id = MemberUtil.getUserIdFromPing(pingText);
        User user2 = user = id.isEmpty() ? null : jda.getUserById(id);
        if (user == null && !id.isEmpty()) {
            LightmansDiscordIntegration.LOGGER.warn("No guild member could be found with id '" + id + "'");
        } else if (user != null) {
            LightmansDiscordIntegration.LOGGER.info("Found member with id '" + id + "'");
        }
        return user;
    }

    public static Member getMemberFromPing(Guild guild, String pingText) {
        Member member;
        String id = MemberUtil.getUserIdFromPing(pingText);
        Member member2 = member = id.isEmpty() ? null : guild.getMemberById(id);
        if (member == null && !id.isEmpty()) {
            LightmansDiscordIntegration.LOGGER.warn("No guild member could be found with id '" + id + "'");
        } else if (member != null) {
            LightmansDiscordIntegration.LOGGER.info("Found member with id '" + id + "'");
        }
        return member;
    }

    public static SafeMemberReference getMemberFromPing(SafeGuildReference guild, String pingText) {
        SafeMemberReference member;
        String id = MemberUtil.getUserIdFromPing(pingText);
        SafeMemberReference safeMemberReference = member = id.isEmpty() ? null : guild.getMember(id);
        if (member == null && !id.isEmpty()) {
            LightmansDiscordIntegration.LOGGER.warn("No guild member could be found with id '" + id + "'");
        } else if (member != null) {
            LightmansDiscordIntegration.LOGGER.info("Found member with id '" + id + "'");
        }
        return member;
    }
}

