/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmansdiscord.util;

import io.github.lightman314.lightmansdiscord.LDIConfig;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeGuildReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeMemberReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.SafeRoleReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafeMessageChannelReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.channels.SafeTextChannelReference;
import io.github.lightman314.lightmansdiscord.api.jda.data.messages.SafeMessageReference;
import io.github.lightman314.lightmansdiscord.util.MemberUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;

public class MessageUtil {
    public static void sendTextMessage(MessageChannel channel, String message) {
        if (channel == null) {
            return;
        }
        message = MessageUtil.clearFormatting(message);
        MessageUtil.splitMessage(message).forEach(val -> {
            if (!val.isEmpty()) {
                channel.sendMessage((CharSequence)val).queue();
            }
        });
    }

    public static void sendTextMessage(MessageChannel channel, List<String> messages) {
        if (channel == null) {
            return;
        }
        messages.replaceAll(MessageUtil::clearFormatting);
        MessageUtil.combineMessages(messages).forEach(val -> {
            if (!val.isEmpty()) {
                channel.sendMessage((CharSequence)val).queue();
            }
        });
    }

    public static void sendPrivateMessage(User user, String message) {
        user.openPrivateChannel().queue(channel -> MessageUtil.splitMessage(MessageUtil.clearFormatting(message)).forEach(val -> {
            if (!val.isEmpty()) {
                channel.sendMessage((CharSequence)val).queue();
            }
        }));
    }

    public static void sendPrivateMessage(User user, List<String> messages) {
        messages.replaceAll(MessageUtil::clearFormatting);
        user.openPrivateChannel().queue(channel -> MessageUtil.combineMessages(messages).forEach(val -> {
            if (!val.isEmpty()) {
                channel.sendMessage((CharSequence)val).queue();
            }
        }));
    }

    public static List<String> splitMessage(String message) {
        ArrayList<String> output = new ArrayList<String>();
        if (message.length() <= 2000) {
            output.add(message);
            return output;
        }
        String[] split = message.split("\n");
        StringBuilder bufferString = new StringBuilder();
        for (String s : split) {
            if ((bufferString + s + "\n").length() > 2000) {
                output.add(bufferString.toString());
                bufferString = new StringBuilder(s + "\n");
                continue;
            }
            bufferString.append(s).append("\n");
        }
        output.add(bufferString.toString());
        return output;
    }

    public static List<String> combineMessages(List<String> messages) {
        ArrayList<String> output = new ArrayList<String>();
        if (messages.size() < 2) {
            return messages;
        }
        StringBuilder bufferString = new StringBuilder();
        for (String s : messages) {
            if ((bufferString + "\n" + s).length() > 2000) {
                output.add(bufferString.toString());
                bufferString = new StringBuilder(s + "\n");
                continue;
            }
            bufferString.append(s).append("\n");
        }
        output.add(bufferString.toString());
        return output;
    }

    public static String clearFormatting(String message) {
        StringWriter result = new StringWriter();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String formatMinecraftMessage(String minecraftMessage, @Nullable SafeGuildReference guild) {
        Object secondHalf;
        String[] splitText;
        String firstHalf;
        int indexof;
        if (!((Boolean)LDIConfig.SERVER.chatAllowPingEveryone.get()).booleanValue()) {
            minecraftMessage = ((String)minecraftMessage).replaceAll("@everyone", "@**everyone**");
        }
        if (guild == null) {
            return minecraftMessage;
        }
        int indexOffset = 0;
        while (((String)minecraftMessage).substring(indexOffset).contains("@")) {
            indexof = ((String)minecraftMessage).substring(indexOffset).indexOf(64) + indexOffset;
            indexOffset = indexof + 1;
            firstHalf = ((String)minecraftMessage).substring(0, indexof);
            splitText = ((String)minecraftMessage).substring(indexOffset).split(" ", 2);
            secondHalf = "";
            if (splitText.length > 1) {
                secondHalf = " " + splitText[1];
            }
            String pingText = splitText[0];
            String[] splitPing = pingText.split("#", 2);
            String pingName = splitPing[0];
            String pingDiscriminator = "";
            if (splitPing.length > 1) {
                pingDiscriminator = splitPing[1];
            }
            SafeMemberReference foundMember = null;
            List<SafeMemberReference> members = guild.getMembersByEffectiveName(pingName);
            if (members.size() == 1) {
                foundMember = members.get(0);
            } else {
                members = guild.getMembersByName(pingName);
                if (members.size() == 1) {
                    foundMember = members.get(0);
                } else if (members.size() > 1 && !pingDiscriminator.isEmpty()) {
                    for (int i = 0; i < members.size() && foundMember == null; ++i) {
                        if (!members.get(i).getDiscriminator().equals(pingDiscriminator)) continue;
                        foundMember = members.get(i);
                    }
                }
            }
            if (foundMember != null) {
                minecraftMessage = firstHalf + "<@!" + foundMember.getID() + ">" + (String)secondHalf;
                indexOffset += foundMember.getID().length();
                continue;
            }
            SafeRoleReference foundRole = null;
            List<SafeRoleReference> roles = guild.getRoles();
            for (int i = 0; i < roles.size() && foundRole == null; ++i) {
                if (!roles.get(i).getName().equals(pingName)) continue;
                foundRole = roles.get(i);
            }
            if (foundRole == null) continue;
            minecraftMessage = firstHalf + "<@&" + foundRole.getID() + ">" + (String)secondHalf;
            indexOffset += foundRole.getID().length();
        }
        indexOffset = 0;
        while (((String)minecraftMessage).substring(indexOffset).contains("#")) {
            indexof = ((String)minecraftMessage).substring(indexOffset).indexOf(35) + indexOffset;
            indexOffset = indexof + 1;
            firstHalf = ((String)minecraftMessage).substring(0, indexof);
            splitText = ((String)minecraftMessage).substring(indexOffset).split(" ", 2);
            secondHalf = "";
            if (splitText.length > 1) {
                secondHalf = " " + splitText[1];
            }
            String channelName = splitText[0];
            List<SafeTextChannelReference> channels = guild.getChannels();
            SafeMessageChannelReference foundChannel = null;
            for (int i = 0; i < channels.size() && foundChannel == null; ++i) {
                if (!channels.get(i).getName().equals(channelName)) continue;
                foundChannel = channels.get(i);
            }
            if (foundChannel == null) continue;
            minecraftMessage = firstHalf + "<#" + foundChannel.getID() + ">" + (String)secondHalf;
            indexOffset += foundChannel.getID().length();
        }
        return minecraftMessage;
    }

    public static String formatMessageText(SafeMessageReference message, SafeGuildReference guild) {
        String rawMessage = message.getRaw();
        StringBuilder messageText = new StringBuilder();
        int currentModifier = 0;
        for (int i = 0; i < rawMessage.length(); ++i) {
            String partialMessage = rawMessage.substring(i);
            if (partialMessage.startsWith("***")) {
                if (currentModifier == 3) {
                    currentModifier = 0;
                    messageText.append("\u00a7r");
                    i += 2;
                    continue;
                }
                if (partialMessage.substring(1).contains("***") && currentModifier == 0) {
                    currentModifier = 3;
                    messageText.append("\u00a7l\u00a7o");
                    i += 2;
                    continue;
                }
                messageText.append(partialMessage.charAt(0));
                continue;
            }
            if (partialMessage.startsWith("**")) {
                if (currentModifier == 2) {
                    currentModifier = 0;
                    messageText.append("\u00a7r");
                    ++i;
                    continue;
                }
                if (partialMessage.substring(1).contains("**") && currentModifier == 0) {
                    currentModifier = 2;
                    messageText.append("\u00a7l");
                    ++i;
                    continue;
                }
                messageText.append(partialMessage.charAt(0));
                continue;
            }
            if (partialMessage.startsWith("*")) {
                if (currentModifier == 1) {
                    currentModifier = 0;
                    messageText.append("\u00a7r");
                    continue;
                }
                if (partialMessage.substring(1).contains("*") && currentModifier == 0) {
                    currentModifier = 1;
                    messageText.append("\u00a7o");
                    continue;
                }
                messageText.append(partialMessage.charAt(0));
                continue;
            }
            messageText.append(partialMessage.charAt(0));
        }
        if (guild != null) {
            int indexOffset = 0;
            while (messageText.substring(indexOffset).contains("<")) {
                String channelId;
                SafeTextChannelReference foundChannel;
                int startIndex = messageText.substring(indexOffset).indexOf(60) + indexOffset;
                int endIndex = messageText.substring(indexOffset = startIndex + 1).indexOf(62) + indexOffset;
                if (endIndex < 0) continue;
                String frontText = messageText.substring(0, startIndex);
                String processText = messageText.substring(startIndex, endIndex + 1);
                String endText = "";
                if (endIndex < messageText.length()) {
                    endText = messageText.substring(endIndex + 1);
                }
                if (processText.startsWith("<@&")) {
                    String roleId = processText.substring(3, processText.length() - 1);
                    SafeRoleReference foundRole = guild.getRole(roleId);
                    if (foundRole == null) continue;
                    messageText = new StringBuilder(frontText + "@" + foundRole.getName() + endText);
                    continue;
                }
                if (processText.startsWith("<@")) {
                    SafeMemberReference foundMember = MemberUtil.getMemberFromPing(guild, processText);
                    if (foundMember == null) continue;
                    messageText = new StringBuilder(frontText + "@" + foundMember.getEffectiveName() + endText);
                    continue;
                }
                if (!processText.startsWith("<#") || (foundChannel = guild.getChannel(channelId = processText.substring(2, processText.length() - 1))) == null) continue;
                messageText = new StringBuilder(frontText + "#" + foundChannel.getName() + endText);
            }
        }
        return messageText.toString();
    }
}

