/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.particles;

import com.almostreliable.ponderjs.particles.ParticleTransformation;
import com.mojang.math.Vector3f;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import com.simibubi.create.foundation.utility.Color;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.phys.Vec3;

public abstract class ParticleDataBuilder<O extends ParticleDataBuilder<O, PO>, PO extends ParticleOptions> {
    final List<ParticleTransformation> transformations = new ArrayList<ParticleTransformation>();
    int density = 1;
    @Nullable
    Float gravity = null;
    @Nullable
    Boolean physics = null;
    @Nullable
    Boolean collision = null;
    @Nullable
    dev.latvian.mods.rhino.mod.util.color.Color color = null;
    @Nullable
    Float roll = null;
    @Nullable
    Float friction = null;
    @Nullable
    Float scale = null;
    @Nullable
    Integer lifetime = null;

    public O density(int density) {
        this.density = density;
        return this.getSelf();
    }

    public O gravity(float gravity) {
        this.gravity = Float.valueOf(gravity);
        return this.getSelf();
    }

    public O physics(boolean physics) {
        this.physics = physics;
        return this.getSelf();
    }

    public O collision(boolean collision) {
        this.collision = collision;
        return this.getSelf();
    }

    public O color(dev.latvian.mods.rhino.mod.util.color.Color color) {
        this.color = color;
        return this.getSelf();
    }

    public O roll(float roll) {
        this.roll = Float.valueOf(roll);
        return this.getSelf();
    }

    public O friction(float friction) {
        this.friction = Float.valueOf(friction);
        return this.getSelf();
    }

    public O scale(float scale) {
        this.scale = Float.valueOf(scale);
        return this.getSelf();
    }

    public O lifetime(int lifetime) {
        this.lifetime = lifetime;
        return this.getSelf();
    }

    public O motion(Vec3 motion) {
        return this.transformMotion((partialTicks, m) -> motion);
    }

    public O speed(Vec3 speed) {
        return this.transformMotion((partialTick, motion) -> new Vec3(Create.RANDOM.nextGaussian() * speed.f_82479_, Create.RANDOM.nextGaussian() * speed.f_82480_, Create.RANDOM.nextGaussian() * speed.f_82481_));
    }

    public O withinBlockSpace() {
        return this.transformPosition((partialTicks, position) -> new Vec3(Math.floor(position.f_82479_) + (double)Create.RANDOM.nextFloat(), Math.floor(position.f_82480_) + (double)Create.RANDOM.nextFloat(), Math.floor(position.f_82481_) + (double)Create.RANDOM.nextFloat()));
    }

    public O area(Vec3 area) {
        return this.transformPosition((partialTicks, position) -> new Vec3(position.f_82479_ + (double)Create.RANDOM.nextFloat() * (area.f_82479_ - position.f_82479_), position.f_82480_ + (double)Create.RANDOM.nextFloat() * (area.f_82480_ - position.f_82480_), position.f_82481_ + (double)Create.RANDOM.nextFloat() * (area.f_82481_ - position.f_82481_)));
    }

    public O delta(Vec3 delta) {
        return this.transformPosition((partialTicks, position) -> new Vec3(position.f_82479_ + Create.RANDOM.nextGaussian() * delta.f_82479_, position.f_82480_ + Create.RANDOM.nextGaussian() * delta.f_82480_, position.f_82481_ + Create.RANDOM.nextGaussian() * delta.f_82481_));
    }

    public O transform(ParticleTransformation transformer) {
        this.transformations.add(transformer);
        return this.getSelf();
    }

    public O transformPosition(ParticleTransformation.Simple transformer) {
        return this.transform(ParticleTransformation.onlyPosition(transformer));
    }

    public O transformMotion(ParticleTransformation.Simple transformer) {
        return this.transform(ParticleTransformation.onlyMotion(transformer));
    }

    abstract PO createOptions();

    protected O getSelf() {
        return (O)this;
    }

    public static class RotationIndicatorParticleDataBuilder
    extends ParticleDataBuilder<RotationIndicatorParticleDataBuilder, RotationIndicatorParticleData> {
        private final float radius1;
        private final float radius2;
        private final Direction.Axis axis;
        private float rotationSpeed = 1.0f;

        public RotationIndicatorParticleDataBuilder(float radius1, float radius2, Direction.Axis axis) {
            this.radius1 = radius1;
            this.radius2 = radius2;
            this.axis = axis;
        }

        public RotationIndicatorParticleDataBuilder rotationSpeed(float rotationSpeed) {
            this.rotationSpeed = rotationSpeed;
            return (RotationIndicatorParticleDataBuilder)this.getSelf();
        }

        @Override
        RotationIndicatorParticleData createOptions() {
            dev.latvian.mods.rhino.mod.util.color.Color c = this.color == null ? ColorWrapper.BLACK : this.color;
            char axisChar = this.axis.name().charAt(0);
            int lTime = this.lifetime == null ? 40 : this.lifetime;
            return new RotationIndicatorParticleData(c.getRgbJS(), this.rotationSpeed, this.radius1, this.radius2, lTime, axisChar);
        }
    }

    public static class DustParticleDataBuilder
    extends ParticleDataBuilder<DustParticleDataBuilder, DustParticleOptionsBase> {
        final dev.latvian.mods.rhino.mod.util.color.Color fromColor;
        @Nullable
        final dev.latvian.mods.rhino.mod.util.color.Color toColor;

        public DustParticleDataBuilder(dev.latvian.mods.rhino.mod.util.color.Color fromColor, @Nullable dev.latvian.mods.rhino.mod.util.color.Color toColor) {
            this.fromColor = fromColor;
            this.toColor = toColor;
        }

        @Override
        public DustParticleDataBuilder color(dev.latvian.mods.rhino.mod.util.color.Color color) {
            return this;
        }

        @Override
        DustParticleOptionsBase createOptions() {
            float s = this.scale == null ? 1.0f : this.scale.floatValue();
            Vector3f fC = new Color(this.fromColor.getRgbJS()).asVectorF();
            if (this.toColor == null) {
                return new DustParticleOptions(fC, s);
            }
            Vector3f toC = new Color(this.toColor.getRgbJS()).asVectorF();
            return new DustColorTransitionOptions(fC, toC, s);
        }
    }

    public static class Static
    extends ParticleDataBuilder<Static, ParticleOptions> {
        private final ParticleOptions type;

        public Static(ParticleOptions type) {
            this.type = type;
        }

        @Override
        ParticleOptions createOptions() {
            return this.type;
        }
    }
}

