/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.bettercombat.BetterCombat;
import net.bettercombat.PlatformClient;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.MinecraftClient_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.client.BetterCombatClientEvents;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.client.BetterCombatKeybindings;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.config.ClientConfigWrapper;
import net.bettercombat.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.bettercombat.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.client.MinecraftClientAccessor;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.PatternMatching;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientInject
implements MinecraftClient_BetterCombat {
    @Shadow
    public ClientLevel f_91073_;
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;
    @Shadow
    private int f_91011_;
    private boolean isHoldingAttackInput = false;
    private boolean isHarvesting = false;
    private String textToRender = null;
    private int textFade = 0;
    private ItemStack upswingStack;
    private ItemStack lastAttacedWithItemStack;
    private int upswingTicks = 0;
    private int lastAttacked = 1000;
    private float lastSwingDuration = 0.0f;
    private int comboReset = 0;
    private List<Entity> targetsInReach = null;

    private Minecraft thisClient() {
        return (Minecraft)this;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(GameConfig args, CallbackInfo ci) {
        this.setupTextRenderer();
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="TAIL")})
    private void disconnect_TAIL(Screen screen, CallbackInfo ci) {
        BetterCombatClient.ENABLED = false;
    }

    private void setupTextRenderer() {
        HudRenderCallback.EVENT.register((matrices, f) -> {
            if (this.textToRender != null && !this.textToRender.isEmpty()) {
                Minecraft client = Minecraft.m_91087_();
                Font textRenderer = client.f_91065_.m_93082_();
                int scaledWidth = client.m_91268_().m_85445_();
                int scaledHeight = client.m_91268_().m_85446_();
                int i = textRenderer.m_92895_(this.textToRender);
                int j = (scaledWidth - i) / 2;
                int k = scaledHeight - 59 - 14;
                int l = 0;
                if (!client.f_91072_.m_105205_()) {
                    k += 14;
                }
                if ((l = (int)((float)this.textFade * 256.0f / 10.0f)) > 255) {
                    l = 255;
                }
                if (l > 0) {
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    Objects.requireNonNull(textRenderer);
                    Gui.m_93172_((PoseStack)matrices, (int)(j - 2), (int)(k - 2), (int)(j + i + 2), (int)(k + 9 + 2), (int)client.f_91066_.m_92143_(0));
                    textRenderer.m_92750_(matrices, this.textToRender, (float)j, (float)k, 0xFFFFFF + (l << 24));
                    RenderSystem.m_69461_();
                }
            }
            if (this.textFade <= 0) {
                this.textToRender = null;
            }
        });
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doAttack(CallbackInfoReturnable<Boolean> info) {
        if (!BetterCombatClient.ENABLED) {
            return;
        }
        Minecraft client = this.thisClient();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(client.f_91074_.m_21205_());
        if (attributes != null) {
            if (this.isTargetingMineableBlock() || this.isHarvesting) {
                this.isHarvesting = true;
                return;
            }
            this.startUpswing(attributes);
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_handleBlockBreaking(boolean bl, CallbackInfo ci) {
        if (!BetterCombatClient.ENABLED) {
            return;
        }
        Minecraft client = this.thisClient();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(client.f_91074_.m_21205_());
        if (attributes != null) {
            boolean isPressed = client.f_91066_.f_92096_.m_90857_();
            if (isPressed && !this.isHoldingAttackInput) {
                if (this.isTargetingMineableBlock() || this.isHarvesting) {
                    this.isHarvesting = true;
                    return;
                }
                ci.cancel();
            }
            if (BetterCombatClient.config.isHoldToAttackEnabled && isPressed) {
                this.isHoldingAttackInput = true;
                this.startUpswing(attributes);
                ci.cancel();
            } else {
                this.isHarvesting = false;
                this.isHoldingAttackInput = false;
            }
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doItemUse(CallbackInfo ci) {
        if (!BetterCombatClient.ENABLED) {
            return;
        }
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        double upswingRate = hand.upswingRate();
        if (this.upswingTicks > 0 || (double)this.f_91074_.m_36403_(0.0f) < 1.0 - upswingRate) {
            ci.cancel();
        }
    }

    private boolean isTargetingMineableBlock() {
        if (!BetterCombatClient.config.isMiningWithWeaponsEnabled) {
            return false;
        }
        if (BetterCombatClient.config.isAttackInsteadOfMineWhenEnemiesCloseEnabled && this.hasTargetsInReach()) {
            return false;
        }
        Minecraft client = this.thisClient();
        HitResult crosshairTarget = client.f_91077_;
        if (crosshairTarget != null && crosshairTarget.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)crosshairTarget;
            BlockPos pos = blockHitResult.m_82425_();
            BlockState clicked = this.f_91073_.m_8055_(pos);
            if (this.shouldSwingThruGrass()) {
                if (!clicked.m_60812_((BlockGetter)this.f_91073_, pos).m_83281_() || clicked.m_60800_((BlockGetter)this.f_91073_, pos) != 0.0f) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean shouldSwingThruGrass() {
        if (!BetterCombatClient.config.isSwingThruGrassEnabled) {
            return false;
        }
        String regex = BetterCombatClient.config.swingThruGrassBlacklist;
        if (regex == null || regex.isEmpty()) {
            return true;
        }
        ItemStack itemStack = this.f_91074_.m_21205_();
        String id = Registry.f_122827_.m_7981_((Object)itemStack.m_41720_()).toString();
        return !PatternMatching.matches(id, regex);
    }

    private void startUpswing(WeaponAttributes attributes) {
        if (this.f_91074_.m_108637_()) {
            return;
        }
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        float upswingRate = (float)hand.upswingRate();
        if (this.upswingTicks > 0 || this.f_91074_.m_6117_() || (double)this.f_91074_.m_36403_(0.0f) < 1.0 - (double)upswingRate) {
            return;
        }
        this.f_91074_.m_21253_();
        this.lastAttacked = 0;
        this.upswingStack = this.f_91074_.m_21205_();
        float attackCooldownTicksFloat = PlayerAttackHelper.getAttackCooldownTicksCapped((Player)this.f_91074_);
        int attackCooldownTicks = Math.round(attackCooldownTicksFloat);
        this.comboReset = Math.round(attackCooldownTicksFloat * BetterCombat.config.combo_reset_rate);
        this.upswingTicks = Math.max(Math.round(attackCooldownTicksFloat * upswingRate), 1);
        this.lastSwingDuration = attackCooldownTicksFloat;
        this.f_91011_ = attackCooldownTicks;
        this.setMiningCooldown(attackCooldownTicks);
        String animationName = hand.attack().animation();
        boolean isOffHand = hand.isOffHand();
        AnimatedHand animatedHand = AnimatedHand.from(isOffHand, attributes.isTwoHanded());
        ((PlayerAttackAnimatable)this.f_91074_).playAttackAnimation(animationName, animatedHand, attackCooldownTicksFloat, upswingRate);
        ClientPlayNetworking.send(Packets.AttackAnimation.ID, new Packets.AttackAnimation(this.f_91074_.m_142049_(), animatedHand, animationName, attackCooldownTicksFloat, upswingRate).write());
        BetterCombatClientEvents.ATTACK_START.invoke(handler -> handler.onPlayerAttackStart(this.f_91074_, hand));
    }

    private void cancelSwingIfNeeded() {
        if (this.upswingStack != null && !MinecraftClientInject.areItemStackEqual(this.f_91074_.m_21205_(), this.upswingStack)) {
            this.cancelWeaponSwing();
            return;
        }
    }

    private void attackFromUpswingIfNeeded() {
        if (this.upswingTicks > 0) {
            --this.upswingTicks;
            if (this.upswingTicks == 0) {
                this.performAttack();
                this.upswingStack = null;
            }
        }
    }

    private void resetComboIfNeeded() {
        if (this.lastAttacked > this.comboReset && this.getComboCount() > 0) {
            this.setComboCount(0);
        }
        if (!PlayerAttackHelper.shouldAttackWithOffHand((Player)this.f_91074_, this.getComboCount()) && (this.f_91074_.m_21205_() == null || this.lastAttacedWithItemStack != null && !this.lastAttacedWithItemStack.m_41720_().equals(this.f_91074_.m_21205_().m_41720_()))) {
            this.setComboCount(0);
        }
    }

    private boolean shouldUpdateTargetsInReach() {
        if (BetterCombatClient.config.isHighlightCrosshairEnabled || BetterCombatClient.config.isAttackInsteadOfMineWhenEnemiesCloseEnabled) {
            return this.targetsInReach == null;
        }
        return false;
    }

    private void updateTargetsInReach(List<Entity> targets) {
        this.targetsInReach = targets;
    }

    private void updateTargetsIfNeeded() {
        if (this.shouldUpdateTargetsInReach()) {
            AttackHand hand = PlayerAttackHelper.getCurrentAttack((Player)this.f_91074_, this.getComboCount());
            WeaponAttributes attributes = WeaponRegistry.getAttributes(this.f_91074_.m_21205_());
            List<Entity> targets = List.of();
            if (attributes != null) {
                targets = TargetFinder.findAttackTargets((Player)this.f_91074_, this.getCursorTarget(), hand.attack(), attributes.attackRange());
            }
            this.updateTargetsInReach(targets);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pre_Tick(CallbackInfo ci) {
        if (this.f_91074_ == null) {
            return;
        }
        this.targetsInReach = null;
        ++this.lastAttacked;
        this.cancelSwingIfNeeded();
        this.attackFromUpswingIfNeeded();
        this.updateTargetsIfNeeded();
        this.resetComboIfNeeded();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void post_Tick(CallbackInfo ci) {
        if (this.f_91074_ == null) {
            return;
        }
        if (BetterCombatKeybindings.toggleMineKeyBinding.m_90859_()) {
            BetterCombatClient.config.isMiningWithWeaponsEnabled = !BetterCombatClient.config.isMiningWithWeaponsEnabled;
            AutoConfig.getConfigHolder(ClientConfigWrapper.class).save();
            this.textToRender = I18n.m_118938_((String)(BetterCombatClient.config.isMiningWithWeaponsEnabled ? "hud.bettercombat.mine_with_weapons_on" : "hud.bettercombat.mine_with_weapons_off"), (Object[])new Object[0]);
            this.textFade = 40;
        }
        if (this.textFade > 0) {
            --this.textFade;
        }
    }

    private void performAttack() {
        if (BetterCombatKeybindings.feintKeyBinding.m_90857_()) {
            this.f_91074_.m_36334_();
            this.cancelWeaponSwing();
            return;
        }
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        WeaponAttributes.Attack attack = hand.attack();
        double upswingRate = hand.upswingRate();
        if ((double)this.f_91074_.m_36403_(0.0f) < 1.0 - upswingRate) {
            return;
        }
        Entity cursorTarget = this.getCursorTarget();
        List<Entity> targets = TargetFinder.findAttackTargets((Player)this.f_91074_, cursorTarget, attack, hand.attributes().attackRange());
        this.updateTargetsInReach(targets);
        if (targets.size() == 0) {
            PlatformClient.onEmptyLeftClick((Player)this.f_91074_);
        }
        ClientPlayNetworking.send(Packets.C2S_AttackRequest.ID, new Packets.C2S_AttackRequest(this.getComboCount(), this.f_91074_.m_6144_(), this.f_91074_.m_150109_().f_35977_, targets).write());
        for (Entity target : targets) {
            this.f_91074_.m_5706_(target);
        }
        this.f_91074_.m_36334_();
        BetterCombatClientEvents.ATTACK_HIT.invoke(handler -> handler.onPlayerAttackStart(this.f_91074_, hand, targets, cursorTarget));
        this.setComboCount(this.getComboCount() + 1);
        if (!hand.isOffHand()) {
            this.lastAttacedWithItemStack = hand.itemStack();
        }
    }

    private AttackHand getCurrentHand() {
        return PlayerAttackHelper.getCurrentAttack((Player)this.f_91074_, this.getComboCount());
    }

    private void setComboCount(int comboCount) {
        ((PlayerAttackProperties)this.f_91074_).setComboCount(comboCount);
    }

    private static boolean areItemStackEqual(ItemStack left, ItemStack right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return ItemStack.m_41728_((ItemStack)left, (ItemStack)right);
    }

    private void setMiningCooldown(int ticks) {
        Minecraft client = this.thisClient();
        ((MinecraftClientAccessor)client).setAttackCooldown(ticks);
    }

    private void cancelWeaponSwing() {
        int downWind = (int)Math.round((double)PlayerAttackHelper.getAttackCooldownTicksCapped((Player)this.f_91074_) * (1.0 - 0.5 * (double)BetterCombat.config.upswing_multiplier));
        ((PlayerAttackAnimatable)this.f_91074_).stopAttackAnimation(downWind);
        ClientPlayNetworking.send(Packets.AttackAnimation.ID, Packets.AttackAnimation.stop(this.f_91074_.m_142049_(), downWind).write());
        this.upswingStack = null;
        this.f_91011_ = 0;
        this.setMiningCooldown(0);
    }

    @Override
    public int getComboCount() {
        return ((PlayerAttackProperties)this.f_91074_).getComboCount();
    }

    @Override
    public boolean hasTargetsInReach() {
        return this.targetsInReach != null && !this.targetsInReach.isEmpty();
    }

    @Override
    public float getSwingProgress() {
        if ((float)this.lastAttacked > this.lastSwingDuration || this.lastSwingDuration <= 0.0f) {
            return 1.0f;
        }
        return (float)this.lastAttacked / this.lastSwingDuration;
    }

    @Override
    public int getUpswingTicks() {
        return this.upswingTicks;
    }

    @Override
    public void cancelUpswing() {
        if (this.upswingTicks > 0) {
            this.cancelWeaponSwing();
        }
    }
}

