/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacksvh.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.BackpackArmorOffsetsManager;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.DefaultBackpackColors;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;

public class IronBackpackModel<T extends Entity>
extends EntityModel<T>
implements IBackpackModel {
    private static final ResourceLocation NO_TINT_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/block/iron_backpack_no_tint.png");
    private static final ResourceLocation MAIN_TINT_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/block/iron_backpack_main.png");
    private static final ResourceLocation ACCENT_TINT_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/block/iron_backpack_accent.png");
    private final ModelPart leftClip;
    private final ModelPart leftPouch;
    private final ModelPart rightClip;
    private final ModelPart rightPouch;

    public IronBackpackModel(ModelPart root) {
        this.leftClip = root.m_171324_("leftClip");
        this.leftPouch = root.m_171324_("leftPouch");
        this.rightClip = root.m_171324_("rightClip");
        this.rightPouch = root.m_171324_("rightPouch");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition leftClip = partdefinition.m_171599_("leftClip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)20.35f, (float)0.0f));
        leftClip.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-0.5f, -1.15f, -6.9f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition rightPouch = partdefinition.m_171599_("rightPouch", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)20.35f, (float)0.0f));
        rightPouch.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.35f, -6.5f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition rightClip = partdefinition.m_171599_("rightClip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)20.35f, (float)0.0f));
        rightClip.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-0.5f, -1.15f, -6.9f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition leftPouch = partdefinition.m_171599_("leftPouch", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)20.35f, (float)0.0f));
        leftPouch.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.35f, -6.5f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    public <L extends LivingEntity, M extends EntityModel<L>> void translateRotateAndScale(M parentModel, LivingEntity livingEntity, PoseStack poseStack, boolean wearsArmor) {
    }

    public <L extends LivingEntity, M extends EntityModel<L>> void render(M parentModel, LivingEntity livingEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int mainColor, int accentColor, Item backpackItem, RenderInfo renderInfo) {
        ModelPart modelPart;
        ModelPart modelPart2;
        if (mainColor == 13394234) {
            mainColor = DefaultBackpackColors.getDefaultMainColor(backpackItem);
        }
        if (accentColor == 6434330) {
            accentColor = DefaultBackpackColors.getDefaultAccentColor(backpackItem);
        }
        float accentRed = (float)(accentColor >> 16 & 0xFF) / 255.0f;
        float accentGreen = (float)(accentColor >> 8 & 0xFF) / 255.0f;
        float accentBlue = (float)(accentColor & 0xFF) / 255.0f;
        float mainRed = (float)(mainColor >> 16 & 0xFF) / 255.0f;
        float mainGreen = (float)(mainColor >> 8 & 0xFF) / 255.0f;
        float mainBlue = (float)(mainColor & 0xFF) / 255.0f;
        poseStack.m_85836_();
        if (parentModel instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)parentModel;
            modelPart2 = humanoidModel.f_102813_;
        } else {
            modelPart2 = null;
        }
        this.translate(livingEntity, poseStack, modelPart2, 1);
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)NO_TINT_TEXTURE));
        this.rightClip.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
        vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)MAIN_TINT_TEXTURE));
        this.rightPouch.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, mainRed, mainGreen, mainBlue, 1.0f);
        vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)ACCENT_TINT_TEXTURE));
        this.rightPouch.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, accentRed, accentGreen, accentBlue, 1.0f);
        poseStack.m_85849_();
        poseStack.m_85836_();
        if (parentModel instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)parentModel;
            modelPart = humanoidModel.f_102814_;
        } else {
            modelPart = null;
        }
        this.translate(livingEntity, poseStack, modelPart, -1);
        vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)NO_TINT_TEXTURE));
        this.leftClip.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
        vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)MAIN_TINT_TEXTURE));
        this.leftPouch.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, mainRed, mainGreen, mainBlue, 1.0f);
        vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)ACCENT_TINT_TEXTURE));
        this.leftPouch.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, accentRed, accentGreen, accentBlue, 1.0f);
        poseStack.m_85849_();
    }

    private void translate(LivingEntity livingEntity, PoseStack poseStack, @Nullable ModelPart legPart, int sideMultiplier) {
        if (legPart != null) {
            legPart.m_104299_(poseStack);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        } else {
            if (livingEntity.m_6047_()) {
                poseStack.m_85837_(0.0, 0.2, 0.0);
            }
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        double zOffset = !livingEntity.m_6844_(EquipmentSlot.LEGS).m_41619_() ? -0.15 + BackpackArmorOffsetsManager.getOffsets((Item)ModItems.GOLD_BACKPACK.get(), livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_()).map(offsets -> offsets.f_86216_).orElse(0.0) : -0.15;
        float yOffset = -1.2f;
        if (livingEntity.m_6162_()) {
            poseStack.m_85841_(0.55f, 0.55f, 0.55f);
            yOffset = -0.6f;
            zOffset *= 0.5;
        }
        poseStack.m_85837_(0.01, (double)yOffset, zOffset * (double)(-sideMultiplier));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
    }

    public void renderBatteryCharge(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float chargeRatio) {
    }

    public void renderFluid(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, FluidStack fluid, float fill, boolean left) {
    }

    public EquipmentSlot getRenderEquipmentSlot() {
        return EquipmentSlot.LEGS;
    }
}

