/*
 * Decompiled with CFR 0.152.
 */
package cofh.dyenamics.client.render.entity;

import cofh.dyenamics.common.entities.DyenamicSheep;
import cofh.dyenamics.core.util.DyenamicDyeColor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class DyenamicSheepFurLayer
extends RenderLayer<DyenamicSheep, SheepModel<DyenamicSheep>> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/sheep/sheep_fur.png");
    protected final SheepFurModel<DyenamicSheep> sheepModel;

    public DyenamicSheepFurLayer(RenderLayerParent<DyenamicSheep, SheepModel<DyenamicSheep>> rendererIn, EntityModelSet modelSet) {
        super(rendererIn);
        this.sheepModel = new SheepFurModel(modelSet.m_171103_(ModelLayers.f_171178_));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, DyenamicSheep sheep, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!sheep.m_29875_() && !sheep.m_20145_()) {
            float b;
            float g;
            float r;
            if (sheep.m_8077_() && "jeb_".equals(sheep.m_7755_().m_6111_())) {
                int i = sheep.f_19797_ / 25 + sheep.m_142049_();
                int j = DyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f3 = ((float)(sheep.f_19797_ % 25) + partialTicks) / 25.0f;
                float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
                float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
                r = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
                g = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
                b = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
            } else {
                DyenamicDyeColor color = sheep.getDyenamicColor();
                if (color.getLightValue() > 0) {
                    int light = Math.min(color.getLightValue() * 2, 15);
                    packedLightIn = Math.max(packedLightIn >> 20 & 0xF, light) << 20 | Math.max(packedLightIn >> 4 & 0xF, light) << 4;
                }
                float[] afloat = DyenamicSheep.getDyeRgb(color);
                r = afloat[0];
                g = afloat[1];
                b = afloat[2];
            }
            DyenamicSheepFurLayer.m_117359_((EntityModel)this.m_117386_(), this.sheepModel, (ResourceLocation)TEXTURE, (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)sheep, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)r, (float)g, (float)b);
        }
    }
}

