/*
 * Decompiled with CFR 0.152.
 */
package cofh.dyenamics.common.entities;

import cofh.dyenamics.core.init.BlockInit;
import cofh.dyenamics.core.init.EntityInit;
import cofh.dyenamics.core.util.DyenamicDyeColor;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.network.NetworkHooks;

public class DyenamicSheep
extends Sheep {
    private static final EntityDataAccessor<Byte> DATA_WOOL_ID = SynchedEntityData.m_135353_(DyenamicSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final Map<DyenamicDyeColor, ItemLike> WOOL_BY_COLOR = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyenamicDyeColor.class), map -> {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            map.put(color, (ItemLike)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get());
        }
    });
    private static final Map<DyeColor, ItemLike> VANILLA_WOOL_BY_COLOR = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, Blocks.f_50041_);
        map.put(DyeColor.ORANGE, Blocks.f_50042_);
        map.put(DyeColor.MAGENTA, Blocks.f_50096_);
        map.put(DyeColor.LIGHT_BLUE, Blocks.f_50097_);
        map.put(DyeColor.YELLOW, Blocks.f_50098_);
        map.put(DyeColor.LIME, Blocks.f_50099_);
        map.put(DyeColor.PINK, Blocks.f_50100_);
        map.put(DyeColor.GRAY, Blocks.f_50101_);
        map.put(DyeColor.LIGHT_GRAY, Blocks.f_50102_);
        map.put(DyeColor.CYAN, Blocks.f_50103_);
        map.put(DyeColor.PURPLE, Blocks.f_50104_);
        map.put(DyeColor.BLUE, Blocks.f_50105_);
        map.put(DyeColor.BROWN, Blocks.f_50106_);
        map.put(DyeColor.GREEN, Blocks.f_50107_);
        map.put(DyeColor.RED, Blocks.f_50108_);
        map.put(DyeColor.BLACK, Blocks.f_50109_);
    });
    protected static final Map<DyenamicDyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(Arrays.stream(DyenamicDyeColor.values()).collect(Collectors.toMap(color -> color, DyenamicSheep::createSheepColor)));

    protected static float[] createSheepColor(DyenamicDyeColor dyeColorIn) {
        if (dyeColorIn == DyenamicDyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = dyeColorIn.getColorComponentValues();
        float f = 0.75f;
        return new float[]{afloat[0] * f, afloat[1] * f, afloat[2] * f};
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float[] getDyeRgb(DyenamicDyeColor dyeColor) {
        return DYE_TO_RGB.get((Object)dyeColor);
    }

    public DyenamicSheep(EntityType<? extends DyenamicSheep> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0, Sheep.class));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WOOL_ID, (Object)0);
    }

    public static void convertToVanilla(DyenamicSheep oldSheep, DyeColor color) {
        Level level = oldSheep.f_19853_;
        if (!level.f_46443_) {
            Sheep sheep = new Sheep(EntityType.f_20520_, level);
            sheep.m_29855_(color);
            DyenamicSheep.convertSheep(oldSheep, sheep);
        }
    }

    public static void convertToDyenamics(Sheep oldSheep, DyenamicDyeColor color) {
        Level level = oldSheep.f_19853_;
        if (!level.f_46443_) {
            DyenamicSheep sheep = new DyenamicSheep((EntityType<? extends DyenamicSheep>)((EntityType)EntityInit.SHEEP.get()), level);
            sheep.setColor(color);
            DyenamicSheep.convertSheep(oldSheep, sheep);
        }
    }

    private static void convertSheep(Sheep oldSheep, Sheep sheep) {
        Level level = oldSheep.f_19853_;
        if (!level.f_46443_) {
            oldSheep.m_142687_(Entity.RemovalReason.DISCARDED);
            sheep.m_20359_((Entity)oldSheep);
            sheep.m_146762_(oldSheep.m_146764_());
            level.m_7967_((Entity)sheep);
        }
    }

    public ResourceLocation m_7582_() {
        if (this.m_29875_()) {
            return this.m_6095_().m_20677_();
        }
        return EntityInit.SHEEP_LOOT.get(this.getDyenamicColor().getTranslationKey());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof DyeItem) {
            if (!this.f_19853_.f_46443_) {
                DyenamicSheep.convertToVanilla(this, ((DyeItem)itemstack.m_41720_()).m_41089_());
                itemstack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (itemstack.m_41720_().equals(Items.f_42639_)) {
            if (!this.f_19853_.f_46443_) {
                DyenamicSheep sheep = new DyenamicSheep((EntityType<? extends DyenamicSheep>)((EntityType)EntityInit.SHEEP.get()), this.f_19853_);
                sheep.m_20359_((Entity)this);
                sheep.m_6863_(true);
                sheep.setColor(this.getDyenamicColor());
                this.f_19853_.m_7967_((Entity)sheep);
                itemstack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(SoundSource category) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12344_, category, 1.0f, 1.0f);
        this.m_29878_(true);
        int i = 1 + this.f_19796_.nextInt(3);
        DyenamicDyeColor color = this.getDyenamicColor();
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = color.getId() > 15 ? this.m_20000_(WOOL_BY_COLOR.get((Object)this.getDyenamicColor()), 1) : this.m_20000_(VANILLA_WOOL_BY_COLOR.get(color.getVanillaColor()), 1);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f), (double)(this.f_19796_.nextFloat() * 0.05f), (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f)));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("Color", (byte)this.getDyenamicColor().getId());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setColor(DyenamicDyeColor.byId(compound.m_128445_("Color")));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public DyenamicDyeColor getDyenamicColor() {
        return DyenamicDyeColor.byId((Byte)this.f_19804_.m_135370_(DATA_WOOL_ID) & 0x7F);
    }

    public void m_29855_(DyeColor color) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_WOOL_ID);
        this.f_19804_.m_135381_(DATA_WOOL_ID, (Object)((byte)(b0 & 0xFFFFFF80 | color.m_41060_() & 0xF)));
    }

    public void setColor(DyenamicDyeColor color) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_WOOL_ID);
        this.f_19804_.m_135381_(DATA_WOOL_ID, (Object)((byte)(b0 & 0xFFFFFF80 | color.getId() & 0x7F)));
    }

    public boolean m_29875_() {
        return (Byte)this.f_19804_.m_135370_(DATA_WOOL_ID) < 0;
    }

    public void m_29878_(boolean sheared) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_WOOL_ID);
        if (sheared) {
            this.f_19804_.m_135381_(DATA_WOOL_ID, (Object)((byte)(b0 | 0xFFFFFF80)));
        } else {
            this.f_19804_.m_135381_(DATA_WOOL_ID, (Object)((byte)(b0 & 0x7F)));
        }
    }

    public Sheep m_142606_(ServerLevel world, AgeableMob mate) {
        if (mate instanceof DyenamicSheep) {
            DyenamicSheep parent = (DyenamicSheep)mate;
            DyenamicSheep child = (DyenamicSheep)((EntityType)EntityInit.SHEEP.get()).m_20615_((Level)world);
            child.setColor(this.getDyeColorMixFromParents(this, parent));
            return child;
        }
        Sheep parent = (Sheep)mate;
        DyenamicDyeColor color = this.getDyeColorMixFromParents(this, parent);
        if (color.getId() < 16) {
            Sheep child = (Sheep)EntityType.f_20520_.m_20615_((Level)world);
            child.m_29855_(color.getAnalogue());
            return child;
        }
        DyenamicSheep child = (DyenamicSheep)((EntityType)EntityInit.SHEEP.get()).m_20615_((Level)world);
        child.setColor(color);
        return child;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof Sheep) {
            return this.m_27593_() && otherAnimal.m_27593_();
        }
        return false;
    }

    protected DyenamicDyeColor getDyeColorMixFromParents(Sheep father, DyenamicSheep mother) {
        return this.f_19853_.f_46441_.nextBoolean() ? DyenamicDyeColor.byId(father.m_29874_().m_41060_()) : mother.getDyenamicColor();
    }

    protected DyenamicDyeColor getDyeColorMixFromParents(DyenamicSheep mother, Sheep father) {
        return this.f_19853_.f_46441_.nextBoolean() ? DyenamicDyeColor.byId(father.m_29874_().m_41060_()) : mother.getDyenamicColor();
    }

    protected DyenamicDyeColor getDyeColorMixFromParents(DyenamicSheep father, DyenamicSheep mother) {
        return this.f_19853_.f_46441_.nextBoolean() ? father.getDyenamicColor() : mother.getDyenamicColor();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos, int fortune) {
        level.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!this.f_19853_.f_46443_) {
            this.m_29878_(true);
            int i = 1 + this.f_19796_.nextInt(3);
            DyenamicDyeColor color = this.getDyenamicColor();
            ItemStack stack = color.getId() > 15 ? new ItemStack(WOOL_BY_COLOR.get((Object)color)) : new ItemStack(VANILLA_WOOL_BY_COLOR.get(color.getVanillaColor()));
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(stack);
            }
            return items;
        }
        return Collections.emptyList();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType((EntityType)EntityType.f_20520_));
    }
}

