/*
 * Decompiled with CFR 0.152.
 */
package cofh.dyenamics.common.items;

import cofh.dyenamics.common.entities.DyenamicSheep;
import cofh.dyenamics.core.util.DyenamicDyeColor;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DyenamicDyeItem
extends Item {
    private static final Map<DyenamicDyeColor, DyenamicDyeItem> COLOR_DYE_ITEM_MAP = Maps.newEnumMap(DyenamicDyeColor.class);
    private final DyenamicDyeColor dyeColor;

    public DyenamicDyeItem(DyenamicDyeColor dyeColorIn, Item.Properties builder) {
        super(builder);
        this.dyeColor = dyeColorIn;
        COLOR_DYE_ITEM_MAP.put(dyeColorIn, this);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Sheep sheep;
        if (target instanceof DyenamicSheep) {
            DyenamicSheep dyenamicSheep = (DyenamicSheep)target;
            if (dyenamicSheep.m_6084_() && !dyenamicSheep.m_29875_() && dyenamicSheep.getDyenamicColor() != this.dyeColor) {
                if (!playerIn.f_19853_.f_46443_) {
                    dyenamicSheep.setColor(this.dyeColor);
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)playerIn.f_19853_.f_46443_);
            }
        } else if (target instanceof Sheep && (sheep = (Sheep)target).m_6084_() && !sheep.m_29875_() && sheep.m_29874_().m_41060_() != this.dyeColor.getId()) {
            if (!playerIn.f_19853_.f_46443_) {
                DyenamicSheep.convertToDyenamics(sheep, this.dyeColor);
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)playerIn.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public DyenamicDyeColor getDyeColor() {
        return this.dyeColor;
    }

    public static DyenamicDyeItem getItem(DyenamicDyeColor color) {
        return COLOR_DYE_ITEM_MAP.get((Object)color);
    }
}

