/*
 * Decompiled with CFR 0.152.
 */
package cofh.dyenamics.common.recipes;

import cofh.dyenamics.common.blocks.DyenamicShulkerBoxBlock;
import cofh.dyenamics.common.items.DyenamicDyeItem;
import cofh.dyenamics.core.init.RecipeSerializerInit;
import cofh.dyenamics.core.util.DyenamicDyeColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class DyenamicShulkerBoxColoringRecipe
extends CustomRecipe {
    public DyenamicShulkerBoxColoringRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level pLevel) {
        int boxes = 0;
        int dyes = 0;
        int slots = inv.m_6643_();
        for (int i = 0; i < slots; ++i) {
            BlockItem blockItem;
            ItemStack slotStack = inv.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            Item item = slotStack.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock) {
                if (boxes >= 1) {
                    return false;
                }
                ++boxes;
                continue;
            }
            if (item instanceof DyenamicDyeItem) {
                if (dyes >= 1) {
                    return false;
                }
                ++dyes;
                continue;
            }
            return false;
        }
        return dyes == 1 && boxes == 1;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack boxStack = ItemStack.f_41583_;
        DyenamicDyeColor color = DyenamicDyeColor.PEACH;
        int slots = inv.m_6643_();
        for (int i = 0; i < slots; ++i) {
            BlockItem blockItem;
            ItemStack slotStack = inv.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            Item item = slotStack.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock) {
                boxStack = slotStack;
                continue;
            }
            color = DyenamicDyeColor.getColor(slotStack);
        }
        ItemStack output = DyenamicShulkerBoxBlock.getDyenamicColoredItemStack(color);
        if (boxStack.m_41782_()) {
            output.m_41751_(boxStack.m_41783_().m_6426_());
        }
        return output;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerInit.SHULKER.get();
    }
}

