/*
 * Decompiled with CFR 0.152.
 */
package cofh.dyenamics.core.init;

import cofh.dyenamics.common.blocks.DyenamicBedBlock;
import cofh.dyenamics.common.blocks.DyenamicCarpetBlock;
import cofh.dyenamics.common.blocks.DyenamicFlammableBlock;
import cofh.dyenamics.common.blocks.DyenamicShulkerBoxBlock;
import cofh.dyenamics.common.blocks.DyenamicStainedGlassBlock;
import cofh.dyenamics.common.blocks.DyenamicStainedGlassPane;
import cofh.dyenamics.common.items.DyenamicBedBlockItem;
import cofh.dyenamics.common.items.DyenamicShulkerBlockItem;
import cofh.dyenamics.core.init.ItemInit;
import cofh.dyenamics.core.util.DyenamicDyeColor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dyenamics");
    public static final Map<String, Map<String, RegistryObject<Block>>> DYED_BLOCKS = new HashMap<String, Map<String, RegistryObject<Block>>>();

    public static void register() {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            BlockInit.registerDyeBlocks(color);
        }
    }

    public static synchronized void registerDyeBlocks(DyenamicDyeColor color) {
        String colorName = color.m_7912_();
        int light = color.getLightValue();
        MaterialColor mapColor = color.getMapColor();
        DyeColor analogue = color.getAnalogue();
        HashMap<String, RegistryObject<Block>> blocks = new HashMap<String, RegistryObject<Block>>();
        DYED_BLOCKS.put(colorName, blocks);
        BlockInit.registerBlockAndItem(colorName, "terracotta", blocks, CreativeModeTab.f_40749_, BlockItem::new, () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)mapColor).m_60913_(1.25f, 4.2f).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "glazed_terracotta", blocks, CreativeModeTab.f_40750_, BlockItem::new, () -> new GlazedTerracottaBlock(BlockBehaviour.Properties.m_60941_((Material)Material.f_76278_, (DyeColor)analogue).m_60978_(1.4f).m_60953_(state -> light)));
        RegistryObject<Block> concrete = BlockInit.registerBlockAndItem(colorName, "concrete", blocks, CreativeModeTab.f_40749_, BlockItem::new, () -> new Block(BlockBehaviour.Properties.m_60941_((Material)Material.f_76278_, (DyeColor)analogue).m_60978_(1.8f).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "concrete_powder", blocks, CreativeModeTab.f_40749_, BlockItem::new, () -> new ConcretePowderBlock((Block)concrete.get(), BlockBehaviour.Properties.m_60941_((Material)Material.f_76317_, (DyeColor)analogue).m_60978_(0.5f).m_60918_(SoundType.f_56746_).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "wool", blocks, CreativeModeTab.f_40749_, BlockItem::new, () -> new DyenamicFlammableBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)mapColor).m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "rockwool", blocks, BlockInit.compatCreativeModeTab("thermal", CreativeModeTab.f_40749_), BlockItem::new, () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "carpet", blocks, CreativeModeTab.f_40750_, BlockItem::new, () -> new DyenamicCarpetBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)mapColor).m_60978_(0.1f).m_60918_(SoundType.f_56745_).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "stained_glass", blocks, CreativeModeTab.f_40749_, BlockItem::new, () -> new DyenamicStainedGlassBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)mapColor).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((a, b, c, d) -> false).m_60924_((a, b, c) -> false).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "stained_glass_pane", blocks, CreativeModeTab.f_40749_, BlockItem::new, () -> new DyenamicStainedGlassPane(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)mapColor).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((a, b, c, d) -> false).m_60924_((a, b, c) -> false).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false).m_60953_(state -> light)));
        RegistryObject<Block> candle = BlockInit.registerBlockAndItem(colorName, "candle", blocks, CreativeModeTab.f_40749_, BlockItem::new, () -> new CandleBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)mapColor).m_60955_().m_60978_(0.1f).m_60918_(SoundType.f_154653_).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "candle_cake", blocks, CreativeModeTab.f_40749_, null, () -> new CandleCakeBlock((Block)candle.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152525_).m_60953_(state -> light)));
        BlockInit.registerBedAndItem(colorName, "bed", blocks, CreativeModeTab.f_40750_, DyenamicBedBlockItem::new, () -> new DyenamicBedBlock(color, BlockBehaviour.Properties.m_60947_((Material)Material.f_76272_, state -> state.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? mapColor : MaterialColor.f_76401_).m_60918_(SoundType.f_56736_).m_60978_(0.2f).m_60955_().m_60953_(state -> light)));
        BlockBehaviour.StatePredicate shulkerBoxBehavior = (blockState, level, blockPos) -> {
            ShulkerBoxBlockEntity box;
            BlockEntity patt5793$temp = level.m_7702_(blockPos);
            return !(patt5793$temp instanceof ShulkerBoxBlockEntity) || (box = (ShulkerBoxBlockEntity)patt5793$temp).m_59702_();
        };
        BlockInit.registerShulkerBoxAndItem(colorName, "shulker_box", blocks, CreativeModeTab.f_40750_, DyenamicShulkerBlockItem::new, () -> new DyenamicShulkerBoxBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76319_, (MaterialColor)mapColor).m_60978_(2.0f).m_60988_().m_60955_().m_60960_(shulkerBoxBehavior).m_60971_(shulkerBoxBehavior)));
    }

    public static synchronized RegistryObject<Block> registerBedAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, CreativeModeTab group, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties().m_41491_(group).m_41487_(1));
    }

    public static synchronized RegistryObject<Block> registerShulkerBoxAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, CreativeModeTab group, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties().m_41491_(group).m_41487_(1));
    }

    public static synchronized RegistryObject<Block> registerBlockAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, CreativeModeTab group, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties().m_41491_(group));
    }

    public static synchronized RegistryObject<Block> registerBlockAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier, Item.Properties itemProperties) {
        String name = color + "_" + nameSuffix;
        RegistryObject block = BLOCKS.register(name, supplier);
        if (itemSupplier != null) {
            ItemInit.ITEMS.register(name, () -> itemSupplier.create((Block)block.get(), itemProperties));
        }
        blockMap.put(nameSuffix, (RegistryObject<Block>)block);
        return block;
    }

    private static CreativeModeTab compatCreativeModeTab(String modId, CreativeModeTab group) {
        if (ModList.get().isLoaded(modId)) {
            return group;
        }
        return null;
    }

    @FunctionalInterface
    public static interface BlockItemSupplier<T extends BlockItem> {
        public T create(Block var1, Item.Properties var2);
    }
}

