/*
 * Decompiled with CFR 0.152.
 */
package cofh.dyenamics.core.util;

import cofh.dyenamics.common.items.DyenamicDyeItem;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.MaterialColor;

public enum DyenamicDyeColor implements StringRepresentable
{
    WHITE(0, "white", 0xF9FFFE, DyeColor.WHITE, MaterialColor.f_76406_, 0xF0F0F0, 0xFFFFFF, 0),
    ORANGE(1, "orange", 16351261, DyeColor.ORANGE, MaterialColor.f_76413_, 15435844, 16738335, 0),
    MAGENTA(2, "magenta", 13061821, DyeColor.MAGENTA, MaterialColor.f_76414_, 12801229, 0xFF00FF, 0),
    LIGHT_BLUE(3, "light_blue", 3847130, DyeColor.LIGHT_BLUE, MaterialColor.f_76415_, 6719955, 10141901, 0),
    YELLOW(4, "yellow", 16701501, DyeColor.YELLOW, MaterialColor.f_76416_, 14602026, 0xFFFF00, 0),
    LIME(5, "lime", 8439583, DyeColor.LIME, MaterialColor.f_76417_, 4312372, 0xBFFF00, 0),
    PINK(6, "pink", 15961002, DyeColor.PINK, MaterialColor.f_76418_, 14188952, 16738740, 0),
    GRAY(7, "gray", 4673362, DyeColor.GRAY, MaterialColor.f_76419_, 0x434343, 0x808080, 0),
    LIGHT_GRAY(8, "light_gray", 0x9D9D97, DyeColor.LIGHT_GRAY, MaterialColor.f_76420_, 0xABABAB, 0xD3D3D3, 0),
    CYAN(9, "cyan", 1481884, DyeColor.CYAN, MaterialColor.f_76421_, 2651799, 65535, 0),
    PURPLE(10, "purple", 8991416, DyeColor.PURPLE, MaterialColor.f_76422_, 8073150, 10494192, 0),
    BLUE(11, "blue", 3949738, DyeColor.BLUE, MaterialColor.f_76361_, 2437522, 255, 0),
    BROWN(12, "brown", 8606770, DyeColor.BROWN, MaterialColor.f_76362_, 5320730, 9127187, 0),
    GREEN(13, "green", 6192150, DyeColor.GREEN, MaterialColor.f_76363_, 3887386, 65280, 0),
    RED(14, "red", 11546150, DyeColor.RED, MaterialColor.f_76364_, 11743532, 0xFF0000, 0),
    BLACK(15, "black", 0x1D1D21, DyeColor.BLACK, MaterialColor.f_76365_, 0x1E1B1B, 0, 0),
    PEACH(16, "peach", 12556403, DyeColor.ORANGE, MaterialColor.f_76400_, 12556403, 11570292, 0),
    AQUAMARINE(17, "aquamarine", 2915711, DyeColor.CYAN, MaterialColor.f_76381_, 2915711, 2717304, 0),
    FLUORESCENT(18, "fluorescent", 15657398, DyeColor.YELLOW, MaterialColor.f_76400_, 15657398, 16117951, 15),
    MINT(19, "mint", 9038008, DyeColor.LIME, MaterialColor.f_76363_, 9038008, 7917475, 0),
    MAROON(20, "maroon", 0x910000, DyeColor.RED, MaterialColor.f_76364_, 0x910000, 0x910000, 0),
    BUBBLEGUM(21, "bubblegum", 16216518, DyeColor.PINK, MaterialColor.f_76418_, 16216518, 14574769, 0),
    LAVENDER(22, "lavender", 0xDD99FF, DyeColor.MAGENTA, MaterialColor.f_76422_, 0xDD99FF, 13339371, 0),
    PERSIMMON(23, "persimmon", 13779225, DyeColor.ORANGE, MaterialColor.f_76373_, 13779225, 12203795, 0),
    CHERENKOV(24, "cherenkov", 104655, DyeColor.LIGHT_BLUE, MaterialColor.f_76415_, 104655, 35002, 8);

    private static final DyenamicDyeColor[] VALUES;
    private static final Int2ObjectOpenHashMap<DyenamicDyeColor> BY_FIREWORK_COLOR;
    private final int id;
    private final String translationKey;
    private final DyeColor analogue;
    private final MaterialColor mapColor;
    private final int colorValue;
    private final int lightValue;
    private final float[] colorComponentValues;
    private final int fireworkColor;
    private final TagKey<Item> tag;
    private final int textColor;

    private DyenamicDyeColor(int idIn, String translationKeyIn, int colorValueIn, DyeColor analogueIn, MaterialColor mapColorIn, int fireworkColorIn, int textColorIn, int lightValueIn) {
        this.id = idIn;
        this.translationKey = translationKeyIn;
        this.colorValue = colorValueIn;
        this.analogue = analogueIn;
        this.mapColor = mapColorIn;
        this.textColor = textColorIn;
        this.lightValue = lightValueIn;
        int i = (colorValueIn & 0xFF0000) >> 16;
        int j = (colorValueIn & 0xFF00) >> 8;
        int k = colorValueIn & 0xFF;
        this.tag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/" + translationKeyIn));
        this.colorComponentValues = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        this.fireworkColor = fireworkColorIn;
    }

    public int getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public float[] getColorComponentValues() {
        return this.colorComponentValues;
    }

    public DyeColor getAnalogue() {
        return this.analogue;
    }

    public MaterialColor getMapColor() {
        return this.mapColor;
    }

    public int getFireworkColor() {
        return this.fireworkColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getLightValue() {
        return this.lightValue;
    }

    public DyeColor getVanillaColor() {
        return DyeColor.m_41053_((int)(this.id % 16));
    }

    public static DyenamicDyeColor[] dyenamicValues() {
        DyenamicDyeColor[] colors = DyenamicDyeColor.values();
        return Arrays.copyOfRange(colors, 16, colors.length);
    }

    public static DyenamicDyeColor byId(int colorId) {
        if (colorId < 0 || colorId >= VALUES.length) {
            colorId = 0;
        }
        return VALUES[colorId];
    }

    public static DyenamicDyeColor byTranslationKey(String translationKeyIn, DyenamicDyeColor fallback) {
        for (DyenamicDyeColor DyenamicDyeColor2 : DyenamicDyeColor.values()) {
            if (!DyenamicDyeColor2.translationKey.equals(translationKeyIn)) continue;
            return DyenamicDyeColor2;
        }
        return fallback;
    }

    @Nullable
    public static DyenamicDyeColor byFireworkColor(int fireworkColorIn) {
        return (DyenamicDyeColor)((Object)BY_FIREWORK_COLOR.get(fireworkColorIn));
    }

    public String toString() {
        return this.getTranslationKey();
    }

    public int getColorValue() {
        return this.colorValue;
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    @Nullable
    public static DyenamicDyeColor getColor(ItemStack stack) {
        return DyenamicDyeColor.getColor(stack.m_41720_());
    }

    @Nullable
    public static DyenamicDyeColor getColor(Item item) {
        if (item instanceof DyenamicDyeItem) {
            return ((DyenamicDyeItem)item).getDyeColor();
        }
        for (DyenamicDyeColor color : VALUES) {
            if (!item.m_204114_().m_203656_(color.getTag())) continue;
            return color;
        }
        return null;
    }

    public String m_7912_() {
        return this.toString();
    }

    static {
        VALUES = (DyenamicDyeColor[])Arrays.stream(DyenamicDyeColor.values()).sorted(Comparator.comparingInt(DyenamicDyeColor::getId)).toArray(DyenamicDyeColor[]::new);
        BY_FIREWORK_COLOR = new Int2ObjectOpenHashMap(Arrays.stream(DyenamicDyeColor.values()).collect(Collectors.toMap(color -> color.fireworkColor, color -> color)));
    }
}

