/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Locale;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.client.IronChestsClient;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.blocks.LockState;

public class ChestRenderer<T extends GenericChestBlockEntity>
implements BlockEntityRenderer<T> {
    private BakedModel lid;
    private BakedModel base;
    private static BakedModel lockUnlocked;
    private static BakedModel lockLocked;
    private final ChestType type;

    public ChestRenderer(ChestType type) {
        this.type = type;
    }

    public void render(@NotNull T chest, float f, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i, int j) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("ironchestRenderer");
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        this.initModels(blockRenderer);
        if (!(chest.m_58900_().m_60734_() instanceof GenericChestBlock)) {
            return;
        }
        poseStack.m_85836_();
        RenderSystem.m_69482_();
        poseStack.m_85837_(0.5, 1.0, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-((Direction)chest.m_58900_().m_61143_((Property)ChestBlock.f_51478_)).m_122435_()));
        poseStack.m_85837_(-0.5, -1.0, -0.5);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.63, 0.065);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-((GenericChestBlockEntity)chest).getOpenness(f)));
        poseStack.m_85837_(0.0, -0.63, -0.065);
        blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(this.type.transparent() ? Sheets.m_110792_() : Sheets.m_110790_()), null, this.lid, 1.0f, 1.0f, 1.0f, i, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(this.type.transparent() ? Sheets.m_110792_() : Sheets.m_110790_()), null, this.base, 1.0f, 1.0f, 1.0f, i, OverlayTexture.f_118083_);
        if (((LockState)((Object)chest.m_58900_().m_61143_(GenericChestBlock.LOCK))).equals((Object)LockState.LOCKED)) {
            blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(Sheets.m_110790_()), null, lockLocked, 1.0f, 1.0f, 1.0f, i, OverlayTexture.f_118083_);
        } else if (((LockState)((Object)chest.m_58900_().m_61143_(GenericChestBlock.LOCK))).equals((Object)LockState.UNLOCKED)) {
            blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(Sheets.m_110790_()), null, lockUnlocked, 1.0f, 1.0f, 1.0f, i, OverlayTexture.f_118083_);
        }
        profiler.m_6180_("renderItems");
        if (this.type.renderItems() && (Minecraft.m_91087_().f_91066_.f_92115_.equals((Object)GraphicsStatus.FABULOUS) || ((GenericChestBlockEntity)chest).getOpenness(f) > 0.0f)) {
            this.renderItems(poseStack, (GenericChestBlockEntity)chest, f, multiBufferSource, i, OverlayTexture.f_118083_);
        }
        profiler.m_7238_();
        poseStack.m_85849_();
        profiler.m_7238_();
    }

    private void initModels(BlockRenderDispatcher dispatcher) {
        if (this.base == null) {
            this.base = IronChestsClient.loadModel(dispatcher, new ResourceLocation("ironchests", "block/chests/" + this.type.name().toLowerCase(Locale.ROOT) + "_chest_base"));
        }
        if (this.lid == null) {
            this.lid = IronChestsClient.loadModel(dispatcher, new ResourceLocation("ironchests", "block/chests/" + this.type.name().toLowerCase(Locale.ROOT) + "_chest_lid"));
        }
        ChestRenderer.checkAndUpdateLocks(dispatcher);
    }

    private static void checkAndUpdateLocks(BlockRenderDispatcher dispatcher) {
        if (lockUnlocked == null) {
            lockUnlocked = IronChestsClient.loadModel(dispatcher, new ResourceLocation("ironchests", "block/unlocked"));
        }
        if (lockLocked == null) {
            lockLocked = IronChestsClient.loadModel(dispatcher, new ResourceLocation("ironchests", "block/locked"));
        }
    }

    private void renderItems(PoseStack poseStack, GenericChestBlockEntity blockEntity, float tickDelta, MultiBufferSource vertexConsumers, int light, int overlay) {
        NonNullList<ItemStack> inv = blockEntity.getItems();
        poseStack.m_85837_(0.26, 0.2, 0.26);
        if (blockEntity.m_58904_() == null) {
            return;
        }
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (((ItemStack)inv.get(index)).m_41720_() != Items.f_41852_) {
                    this.renderItem(0.24 * (double)i, 0.0, 0.24 * (double)j, (ItemStack)inv.get(index), poseStack, (float)blockEntity.m_58904_().m_46467_() + tickDelta, vertexConsumers, light, overlay);
                }
                if (((ItemStack)inv.get(++index)).m_41720_() != Items.f_41852_) {
                    this.renderItem(0.24 * (double)i, 0.2f, 0.24 * (double)j, (ItemStack)inv.get(index), poseStack, (float)blockEntity.m_58904_().m_46467_() + tickDelta, vertexConsumers, light, overlay);
                }
                ++index;
            }
        }
    }

    private void renderItem(double x, double y, double z, ItemStack stack, PoseStack matrices, float rotation, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        matrices.m_85836_();
        matrices.m_85837_(x, y, z);
        matrices.m_85841_(0.5f, 0.5f, 0.5f);
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        renderer.m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, matrices, vertexConsumers, 0);
        matrices.m_85849_();
    }
}

