/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.registry.custom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import tech.thatgravyboat.ironchests.api.IChestRegistry;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;

public class ChestTypeRegistry
implements IChestRegistry {
    public static final ChestTypeRegistry INSTANCE = new ChestTypeRegistry();
    private final Map<String, ChestType> CHESTS = new HashMap<String, ChestType>();

    private ChestTypeRegistry() {
    }

    @Override
    public Map<String, ChestType> getChests() {
        return Collections.unmodifiableMap(this.CHESTS);
    }

    @Override
    public void register(ChestType type) {
        String name = String.format("%s_chest", type.name().toLowerCase(Locale.ROOT));
        if (this.CHESTS.containsKey(name)) {
            throw new IllegalArgumentException("Chest of '" + name + "' already exists.");
        }
        this.CHESTS.put(name, type);
    }
}

