/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.registry.minecraft;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.minecraft.forge.BlockRegistryImpl;

public class BlockRegistry {
    public static void init() {
        ChestTypeRegistry.INSTANCE.getChests().forEach(BlockRegistry::registerBoth);
    }

    private static void registerBoth(String id, ChestType type) {
        BlockRegistry.registerChest(id, type);
        BlockRegistry.registerChestEntity(id, type);
    }

    private static void registerChest(String id, ChestType type) {
        Supplier<GenericChestBlock> register = BlockRegistry.registerBlock(id, () -> new GenericChestBlock(type, type.properties().getProperties()));
        type.registries().setBlockSupplier(register);
    }

    private static void registerChestEntity(String id, ChestType type) {
        Supplier<BlockEntityType<GenericChestBlockEntity>> entityType = BlockRegistry.registerBlockEntity(id, () -> BlockRegistry.createBlockEntityType((pos, state) -> new GenericChestBlockEntity(pos, state, type), (Block)type.registries().getBlock().get()));
        type.registries().setBlockEntityType(entityType);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Block> Supplier<T> registerBlock(String id, Supplier<T> item) {
        void var1_1;
        return BlockRegistryImpl.registerBlock(id, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends BlockEntity, T extends BlockEntityType<E>> Supplier<T> registerBlockEntity(String id, Supplier<T> item) {
        void var1_1;
        return BlockRegistryImpl.registerBlockEntity(id, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityFactory<E> factory, Block ... blocks) {
        void var1_1;
        return BlockRegistryImpl.createBlockEntityType(factory, (Block[])var1_1);
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends BlockEntity> {
        @NotNull
        public T create(BlockPos var1, BlockState var2);
    }
}

