/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.transporter;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterVoxelShapes;
import com.buuz135.industrial.gui.component.custom.TextureGuiComponent;
import com.buuz135.industrial.item.addon.EfficiencyAddonItem;
import com.buuz135.industrial.item.addon.SpeedAddonItem;
import com.buuz135.industrial.proxy.network.TransporterSyncMessage;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.network.Message;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransporterType
implements INBTSerializable<CompoundTag> {
    private IBlockContainer container;
    private TransporterTypeFactory factory;
    private Direction side;
    private TransporterTypeFactory.TransporterAction action;
    private ItemStack speed;
    private ItemStack efficiency;

    public TransporterType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        this.container = container;
        this.factory = factory;
        this.side = side;
        this.action = action;
        this.speed = ItemStack.f_41583_;
        this.efficiency = ItemStack.f_41583_;
    }

    public boolean onUpgradeActivated(Player player, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (!handStack.m_41619_()) {
            if (this.efficiency.m_41619_() && handStack.m_41720_() instanceof EfficiencyAddonItem) {
                this.efficiency = ItemHandlerHelper.copyStackWithSize((ItemStack)handStack, (int)1);
                handStack.m_41774_(1);
                return true;
            }
            if (this.speed.m_41619_() && handStack.m_41720_() instanceof SpeedAddonItem) {
                this.speed = ItemHandlerHelper.copyStackWithSize((ItemStack)handStack, (int)1);
                handStack.m_41774_(1);
                return true;
            }
        }
        return false;
    }

    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)this.getFactory().getUpgradeItem(), 1));
        if (!this.efficiency.m_41619_()) {
            drops.add(this.efficiency);
        }
        if (!this.speed.m_41619_()) {
            drops.add(this.speed);
        }
        return drops;
    }

    public IBlockContainer getContainer() {
        return this.container;
    }

    public Level getWorld() {
        return this.getContainer().getBlockWorld();
    }

    public BlockPos getPos() {
        return this.getContainer().getBlockPosition();
    }

    public TransporterTypeFactory getFactory() {
        return this.factory;
    }

    public Direction getSide() {
        return this.side;
    }

    public TransporterTypeFactory.TransporterAction getAction() {
        return this.action;
    }

    public void update() {
    }

    public void updateClient() {
    }

    public void handleEntity(Entity entity) {
    }

    public void onUpgradeRemoved() {
    }

    public int getRedstoneOutput() {
        return 0;
    }

    public VoxelShape getBorderBoundingBox() {
        switch (this.side) {
            case DOWN: {
                return TransporterVoxelShapes.DOWN_RING;
            }
            case NORTH: {
                return TransporterVoxelShapes.NORTH_RING;
            }
            case EAST: {
                return TransporterVoxelShapes.EAST_RING;
            }
            case SOUTH: {
                return TransporterVoxelShapes.SOUTH_RING;
            }
            case WEST: {
                return TransporterVoxelShapes.WEST_RING;
            }
            case UP: {
                return TransporterVoxelShapes.UP_RING;
            }
        }
        return Shapes.m_83040_();
    }

    public VoxelShape getCenterBoundingBox() {
        if (this.action == TransporterTypeFactory.TransporterAction.EXTRACT) {
            switch (this.side) {
                case DOWN: {
                    return TransporterVoxelShapes.DOWN_MIDDLE_EXTRACT;
                }
                case NORTH: {
                    return TransporterVoxelShapes.NORTH_MIDDLE_EXTRACT;
                }
                case EAST: {
                    return TransporterVoxelShapes.EAST_MIDDLE_EXTRACT;
                }
                case SOUTH: {
                    return TransporterVoxelShapes.SOUTH_MIDDLE_EXTRACT;
                }
                case WEST: {
                    return TransporterVoxelShapes.WEST_MIDDLE_EXTRACT;
                }
                case UP: {
                    return TransporterVoxelShapes.UP_MIDDLE_EXTRACT;
                }
            }
        }
        switch (this.side) {
            case DOWN: {
                return TransporterVoxelShapes.DOWN_MIDDLE_INSERT;
            }
            case NORTH: {
                return TransporterVoxelShapes.NORTH_MIDDLE_INSERT;
            }
            case EAST: {
                return TransporterVoxelShapes.EAST_MIDDLE_INSERT;
            }
            case SOUTH: {
                return TransporterVoxelShapes.SOUTH_MIDDLE_INSERT;
            }
            case WEST: {
                return TransporterVoxelShapes.WEST_MIDDLE_INSERT;
            }
            case UP: {
                return TransporterVoxelShapes.UP_MIDDLE_INSERT;
            }
        }
        return Shapes.m_83040_();
    }

    public boolean hasGui() {
        return true;
    }

    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
    }

    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
    }

    public void syncRender(Direction origin, CompoundTag compoundNBT) {
        IndustrialForegoing.NETWORK.sendToNearby(this.getWorld(), this.getPos(), 32, (Message)new TransporterSyncMessage(this.getPos(), compoundNBT, this.getSide().m_122411_(), origin.m_122411_()));
    }

    public void addComponentsToGui(List<IGuiComponent> componentList) {
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TextureGuiComponent(158, 4, 14, 14, res, 96, 233, new String[0]){

            @Override
            @Nullable
            public List<Component> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
                ArrayList<Component> components = new ArrayList<Component>();
                if (!TransporterType.this.speed.m_41619_()) {
                    components.add(TransporterType.this.speed.m_41786_());
                }
                if (!TransporterType.this.efficiency.m_41619_()) {
                    components.add(TransporterType.this.efficiency.m_41786_());
                }
                if (components.isEmpty()) {
                    components.add((Component)new TextComponent("No Addons"));
                }
                return components;
            }
        });
    }

    public boolean ignoresCollision() {
        return false;
    }

    public void toggleAction() {
        this.action = this.action == TransporterTypeFactory.TransporterAction.EXTRACT ? TransporterTypeFactory.TransporterAction.INSERT : TransporterTypeFactory.TransporterAction.EXTRACT;
        this.getContainer().requestSync();
        if (this.getWorld().f_46443_ && this.getContainer() instanceof BlockEntity) {
            ModelDataManager.requestModelDataRefresh((BlockEntity)((BlockEntity)this.getContainer()));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128379_("Insert", this.action == TransporterTypeFactory.TransporterAction.INSERT);
        compoundNBT.m_128365_("Efficiency", (Tag)this.efficiency.serializeNBT());
        compoundNBT.m_128365_("Speed", (Tag)this.speed.serializeNBT());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.action = nbt.m_128471_("Insert") ? TransporterTypeFactory.TransporterAction.INSERT : TransporterTypeFactory.TransporterAction.EXTRACT;
        this.speed = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Speed"));
        this.efficiency = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Efficiency"));
    }

    public float getSpeed() {
        return this.speed.m_41619_() ? 1.0f : AugmentWrapper.getType((ItemStack)this.speed, (IAugmentType)AugmentTypes.SPEED);
    }

    public float getEfficiency() {
        return this.efficiency.m_41619_() ? 1.0f : (1.0f - AugmentWrapper.getType((ItemStack)this.efficiency, (IAugmentType)AugmentTypes.EFFICIENCY)) / 0.1f * 32.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, PoseStack stack, int combinedOverlayIn, MultiBufferSource buffer, float frame) {
    }
}

