/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.misc.StasisChamberConfig;
import com.buuz135.industrial.module.ModuleMisc;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StasisChamberTile
extends IndustrialAreaWorkingTile<StasisChamberTile> {
    private int getMaxProgress = StasisChamberConfig.maxProgress;
    private int getPowerPerOperation = StasisChamberConfig.powerPerOperation;

    public StasisChamberTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleMisc.STASIS_CHAMBER, RangeManager.RangeType.TOP, false, StasisChamberConfig.powerPerOperation, blockPos, blockState);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation)) {
            List entities = this.f_58857_.m_45976_(Mob.class, this.getWorkingArea().m_83215_());
            for (Mob entity : entities) {
                entity.m_21557_(true);
                entity.getPersistentData().m_128356_("StasisChamberTime", this.f_58857_.m_46467_());
                if (!entity.m_6072_() && this.f_58857_ instanceof ServerLevel) {
                    if (StasisChamberConfig.disableBossBars) {
                        this.f_58857_.m_6907_().forEach(entity1 -> entity.m_6452_((ServerPlayer)entity1));
                    } else {
                        this.f_58857_.m_6907_().forEach(entity1 -> entity.m_6457_((ServerPlayer)entity1));
                    }
                }
                if (!this.f_58857_.f_46441_.nextBoolean() || !this.f_58857_.f_46441_.nextBoolean()) continue;
                entity.m_5634_(1.0f);
            }
            List players = this.f_58857_.m_45976_(Player.class, this.getWorkingArea().m_83215_());
            players.forEach(playerEntity -> {
                playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 25, 135));
                if (this.f_58857_.f_46441_.nextBoolean()) {
                    playerEntity.m_5634_(1.0f);
                }
            });
            return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.getPowerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return Shapes.m_83048_((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).m_83216_((double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_());
    }

    @Nonnull
    public StasisChamberTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<StasisChamberTile> createEnergyStorage() {
        return new EnergyStorageComponent(StasisChamberConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }
}

