/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IRecipeProvider;
import com.hrznstudio.titanium.api.raytrace.DistanceRayTraceResult;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class ConveyorBlock
extends BasicTileBlock<ConveyorTile>
implements SimpleWaterloggedBlock,
IRecipeProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<EnumType> TYPE = EnumProperty.m_61587_((String)"type", EnumType.class);
    private ConveyorItem item;

    public ConveyorBlock(CreativeModeTab group) {
        super("conveyor", BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76413_).m_60910_().m_60978_(2.0f), ConveyorTile.class);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.setItemGroup(group);
    }

    public Supplier<Item> getItemBlockFactory() {
        return this::getItem;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof ConveyorTile) {
            return ((ConveyorTile)tileEntity).getPower();
        }
        return super.m_6378_(blockState, world, pos, side);
    }

    public int m_6376_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof ConveyorTile) {
            return side == Direction.UP ? ((ConveyorTile)tileEntity).getPower() : 0;
        }
        return super.m_6376_(blockState, world, pos, side);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof ConveyorTile) {
            ConveyorUpgrade upgrade;
            if (target instanceof DistanceRayTraceResult && (upgrade = ((ConveyorTile)tileEntity).getUpgradeMap().get(this.getFacingUpgradeHit(state, player.f_19853_, pos, player))) != null) {
                return new ItemStack((ItemLike)upgrade.getFactory().getUpgradeItem(), 1);
            }
            return new ItemStack((ItemLike)this, 1);
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public BlockState getStateAtViewpoint(BlockState state, BlockGetter world, BlockPos pos, Vec3 viewpoint) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof ConveyorTile) {
            state = (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((ConveyorTile)tileEntity).getFacing())).m_61124_(TYPE, (Comparable)((Object)((ConveyorTile)tileEntity).getConveyorType()));
        }
        if (((EnumType)((Object)state.m_61143_(TYPE))).equals((Object)EnumType.FLAT) || ((EnumType)((Object)state.m_61143_(TYPE))).equals((Object)EnumType.FLAT_FAST)) {
            Direction right = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
            Direction left = ((Direction)state.m_61143_((Property)FACING)).m_122428_();
            if (this.isConveyorAndFacing(pos.m_142300_(right), world, left) && this.isConveyorAndFacing(pos.m_142300_(left), world, right) || this.isConveyorAndFacing(pos.m_142300_(right).m_7495_(), world, left) && this.isConveyorAndFacing(pos.m_142300_(left).m_7495_(), world, right) || this.isConveyorAndFacing(pos.m_142300_(right), world, left) || this.isConveyorAndFacing(pos.m_142300_(right).m_7495_(), world, left) || this.isConveyorAndFacing(pos.m_142300_(left), world, right) || this.isConveyorAndFacing(pos.m_142300_(left).m_7495_(), world, right)) {
                // empty if block
            }
        }
        return state;
    }

    private boolean isConveyorAndFacing(BlockPos pos, BlockGetter world, Direction toFace) {
        return world.m_8055_(pos).m_60734_() instanceof ConveyorBlock && (toFace == null || ((Direction)world.m_8055_(pos).m_61143_((Property)FACING)).equals((Object)toFace));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, p_220069_6_);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return ConveyorBlock.getShapes(state, source, pos, conveyorUpgrade -> true);
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos, Predicate<ConveyorUpgrade> filter) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        if (((EnumType)((Object)state.m_61143_(TYPE))).isVertical()) {
            boxes.add(Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0));
        } else {
            boxes.add(Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0));
        }
        BlockEntity entity = source.m_7702_(pos);
        if (entity instanceof ConveyorTile) {
            for (ConveyorUpgrade upgrade : ((ConveyorTile)entity).getUpgradeMap().values()) {
                if (upgrade == null || !filter.test(upgrade)) continue;
                boxes.add(Shapes.m_83064_((AABB)upgrade.getBoundingBox().m_83215_()));
            }
        }
        return boxes;
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        VoxelShape shape = Shapes.m_83040_();
        for (VoxelShape shape1 : ConveyorBlock.getShapes(state, world, pos, conveyorUpgrade -> !conveyorUpgrade.ignoresCollision())) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)shape1, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    public boolean hasCustomBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockEntityType.BlockEntitySupplier<ConveyorTile> getTileEntityFactory() {
        return ConveyorTile::new;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (placer != null) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof ConveyorTile) {
                ((ConveyorTile)tileEntity).setFacing(placer.m_6350_());
            }
            this.updateConveyorPlacing(worldIn, pos, state, true);
        }
    }

    private void updateConveyorPlacing(Level worldIn, BlockPos pos, BlockState state, boolean first) {
        BlockEntity entity = worldIn.m_7702_(pos);
        if (entity instanceof ConveyorTile) {
            Direction direction = ((ConveyorTile)entity).getFacing();
            Direction right = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
            Direction left = ((Direction)state.m_61143_((Property)FACING)).m_122428_();
            if (((ConveyorTile)entity).getUpgradeMap().isEmpty()) {
                if (this.isConveyorAndFacing(pos.m_7494_().m_142300_(direction), (BlockGetter)worldIn, null)) {
                    ((ConveyorTile)entity).setType(((ConveyorTile)entity).getConveyorType().getVertical(Direction.UP));
                } else if (this.isConveyorAndFacing(pos.m_7494_().m_142300_(direction.m_122424_()), (BlockGetter)worldIn, null)) {
                    ((ConveyorTile)entity).setType(((ConveyorTile)entity).getConveyorType().getVertical(Direction.DOWN));
                }
            }
            if (!first) {
                return;
            }
            if (this.isConveyorAndFacing(pos.m_142300_(direction.m_122424_()).m_7495_(), (BlockGetter)worldIn, direction)) {
                this.updateConveyorPlacing(worldIn, pos.m_142300_(direction.m_122424_()).m_7495_(), state, false);
            }
            if (this.isConveyorAndFacing(pos.m_142300_(left).m_7495_(), (BlockGetter)worldIn, right)) {
                this.updateConveyorPlacing(worldIn, pos.m_142300_(left).m_7495_(), state, false);
            }
            if (this.isConveyorAndFacing(pos.m_142300_(right).m_7495_(), (BlockGetter)worldIn, left)) {
                this.updateConveyorPlacing(worldIn, pos.m_142300_(right).m_7495_(), state, false);
            }
            if (this.isConveyorAndFacing(pos.m_142300_(direction).m_7495_(), (BlockGetter)worldIn, direction)) {
                this.updateConveyorPlacing(worldIn, pos.m_142300_(direction).m_7495_(), state, false);
            }
            worldIn.m_7260_(pos, state, state, 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        ItemStack handStack = player.m_21120_(hand);
        if (tileEntity instanceof ConveyorTile) {
            Direction facing = this.getFacingUpgradeHit(state, worldIn, pos, player);
            if (player.m_6047_()) {
                if (facing != null) {
                    ((ConveyorTile)tileEntity).removeUpgrade(facing, true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (facing == null) {
                if (handStack.m_41720_().equals(Items.f_42525_) && !((ConveyorTile)tileEntity).getConveyorType().isFast()) {
                    ((ConveyorTile)tileEntity).setType(((ConveyorTile)tileEntity).getConveyorType().getFast());
                    handStack.m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
                if (handStack.m_41720_().equals(ModuleCore.PLASTIC) && !((ConveyorTile)tileEntity).isSticky()) {
                    ((ConveyorTile)tileEntity).setSticky(true);
                    handStack.m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
                if (handStack.m_41720_() instanceof DyeItem) {
                    ((ConveyorTile)tileEntity).setColor(((DyeItem)handStack.m_41720_()).m_41089_());
                    return InteractionResult.SUCCESS;
                }
            } else if (((ConveyorTile)tileEntity).hasUpgrade(facing)) {
                ConveyorUpgrade upgrade = ((ConveyorTile)tileEntity).getUpgradeMap().get(facing);
                if (upgrade.onUpgradeActivated(player, hand)) {
                    return InteractionResult.SUCCESS;
                }
                if (upgrade.hasGui()) {
                    ((ConveyorTile)tileEntity).openGui(player, facing);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, worldIn, pos, player, hand, ray);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext p_220053_4_) {
        if (((EnumType)((Object)state.m_61143_(TYPE))).isVertical()) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.4, (double)1.0);
        }
        VoxelShape shape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof ConveyorTile) {
            for (ConveyorUpgrade upgrade : ((ConveyorTile)entity).getUpgradeMap().values()) {
                if (upgrade == null) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)upgrade.getBoundingBox().m_83215_()));
            }
        }
        return shape;
    }

    public Direction getFacingUpgradeHit(BlockState state, Level worldIn, BlockPos pos, Player player) {
        VoxelShape hit;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        HitResult result = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockHitResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockHitResult)((BlockHitResult)result), (Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null && tileEntity instanceof ConveyorTile) {
            for (Direction direction : ((ConveyorTile)tileEntity).getUpgradeMap().keySet()) {
                if (!Shapes.m_83157_((VoxelShape)((ConveyorTile)tileEntity).getUpgradeMap().get(direction).getBoundingBox(), (VoxelShape)hit, (BooleanOp)BooleanOp.f_82689_)) continue;
                return direction;
            }
        }
        return null;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        ConveyorTile tile = new ConveyorTile(p_153215_, p_153216_);
        return tile;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43723_().m_6350_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        BlockEntity entity = worldIn.m_7702_(pos);
        if (entity instanceof ConveyorTile) {
            ((ConveyorTile)entity).handleEntityMovement(entityIn);
        }
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList drops = NonNullList.m_122779_();
        Optional entity = TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, ConveyorTile.class);
        entity.ifPresent(tileEntityConveyor -> {
            for (Direction value : Direction.values()) {
                if (!tileEntityConveyor.getUpgradeMap().containsKey(value)) continue;
                ConveyorUpgrade upgrade = tileEntityConveyor.getUpgradeMap().get(value);
                drops.addAll(upgrade.getDrops());
            }
            if (tileEntityConveyor.isSticky()) {
                drops.add((Object)new ItemStack((ItemLike)ModuleCore.PLASTIC.get()));
            }
            if (tileEntityConveyor.getConveyorType().isFast()) {
                drops.add((Object)new ItemStack((ItemLike)Items.f_42525_));
            }
        });
        return drops;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return true;
    }

    public boolean m_5568_() {
        return true;
    }

    public ConveyorItem getItem() {
        return this.item;
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)6).m_126130_("ppp").m_126130_("iri").m_126130_("ppp").m_206416_(Character.valueOf('p'), IndustrialTags.Items.PLASTIC).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('r'), (ItemLike)Items.f_42451_).m_176498_(consumer);
    }

    public static enum EnumType implements StringRepresentable
    {
        FLAT(false, "industrialforegoing:block/conveyor"),
        UP(false, "industrialforegoing:block/conveyor_ramp_inverted", "industrialforegoing:blocks/conveyor_color_inverted"),
        DOWN(false, "industrialforegoing:block/conveyor_ramp"),
        FLAT_FAST(true, "industrialforegoing:block/conveyor", "industrialforegoing:blocks/conveyor_color_fast"),
        UP_FAST(true, "industrialforegoing:block/conveyor_ramp_inverted", "industrialforegoing:blocks/conveyor_color_inverted_fast"),
        DOWN_FAST(true, "industrialforegoing:block/conveyor_ramp", "industrialforegoing:blocks/conveyor_color_fast");

        private boolean fast;
        private String model;
        private String texture;

        private EnumType(boolean fast, String model) {
            this(false, model, "industrialforegoing:blocks/conveyor_color");
        }

        private EnumType(boolean fast, String model, String texture) {
            this.fast = fast;
            this.model = model;
            this.texture = texture;
        }

        public static EnumType getFromName(String name) {
            for (EnumType type : EnumType.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            return FLAT;
        }

        public boolean isFast() {
            return this.fast;
        }

        public EnumType getFast() {
            switch (this) {
                case FLAT: {
                    return FLAT_FAST;
                }
                case UP: {
                    return UP_FAST;
                }
                case DOWN: {
                    return DOWN_FAST;
                }
            }
            return this;
        }

        public EnumType getVertical(Direction facing) {
            if (this.isFast()) {
                if (facing == Direction.UP) {
                    return UP_FAST;
                }
                if (facing == Direction.DOWN) {
                    return DOWN_FAST;
                }
                return FLAT_FAST;
            }
            if (facing == Direction.UP) {
                return UP;
            }
            if (facing == Direction.DOWN) {
                return DOWN;
            }
            return FLAT_FAST;
        }

        public boolean isVertical() {
            return this.isDown() || this.isUp();
        }

        public boolean isUp() {
            return this.equals((Object)UP) || this.equals((Object)UP_FAST);
        }

        public boolean isDown() {
            return this.equals((Object)DOWN) || this.equals((Object)DOWN_FAST);
        }

        public String getName() {
            return this.m_7912_();
        }

        public String getModel() {
            return this.model;
        }

        public String getTexture() {
            return this.texture;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public String m_7912_() {
            return this.toString().toLowerCase();
        }
    }

    private class ConveyorItem
    extends BlockItem {
        public ConveyorItem(Block block, CreativeModeTab group) {
            super(block, new Item.Properties().m_41491_(group));
        }

        @Nullable
        public String getCreatorModId(ItemStack itemStack) {
            return new TranslatableComponent("itemGroup." + this.f_41377_.m_40783_()).getString();
        }
    }

    public static enum EnumSides implements StringRepresentable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH;


        public String getName() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this.toString().toLowerCase();
        }
    }
}

