/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.RegistryObject;

public class ConveyorExtractionUpgrade
extends ConveyorUpgrade {
    public static VoxelShape NORTHBB = Shapes.m_83048_((double)0.25, (double)0.1875, (double)-0.125, (double)0.75, (double)0.6875, (double)0.1875);
    public static VoxelShape SOUTHBB = Shapes.m_83048_((double)0.25, (double)0.1875, (double)0.8125, (double)0.75, (double)0.6875, (double)1.125);
    public static VoxelShape EASTBB = Shapes.m_83048_((double)0.8125, (double)0.1875, (double)0.25, (double)1.125, (double)0.6875, (double)0.75);
    public static VoxelShape WESTBB = Shapes.m_83048_((double)-0.125, (double)0.1875, (double)0.25, (double)0.1875, (double)0.6875, (double)0.75);
    private boolean fast = false;
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;
    private List<ItemEntity> items = new ArrayList<ItemEntity>();

    public ConveyorExtractionUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public VoxelShape getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTHBB;
            }
            case SOUTH: {
                return SOUTHBB;
            }
            case EAST: {
                return EASTBB;
            }
            case WEST: 
        }
        return WESTBB;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("fast", this.fast);
        compound.m_128365_("Filter", (Tag)this.filter.serializeNBT());
        compound.m_128379_("Whitelist", this.whitelist);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.fast = nbt.m_128471_("fast");
        if (nbt.m_128441_("Filter")) {
            this.filter.deserializeNBT(nbt.m_128469_("Filter"));
        }
        this.whitelist = nbt.m_128471_("Whitelist");
    }

    @Override
    public boolean onUpgradeActivated(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (held.m_41720_() == Items.f_42525_ && !this.fast) {
            this.fast = true;
            held.m_41774_(1);
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> getDrops() {
        if (!this.fast) {
            return super.getDrops();
        }
        return Sets.newHashSet((Object[])new ItemStack[]{new ItemStack((ItemLike)this.getFactory().getUpgradeItem(), 1), new ItemStack((ItemLike)Items.f_42525_)});
    }

    @Override
    public void update() {
        if (this.getWorld().f_46443_) {
            return;
        }
        this.items.removeIf(ItemEntity2 -> ItemEntity2.m_32055_().m_41619_() || !ItemEntity2.m_6084_());
        if (this.items.size() >= 20) {
            return;
        }
        if (this.getWorld().m_46467_() % (long)(this.fast ? 10 : 20) == 0L) {
            this.getHandlerCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stack = itemHandler.extractItem(i, 4, true);
                    if (stack.m_41619_() || this.whitelist != this.filter.matches(stack)) continue;
                    ItemEntity item = new ItemEntity(this.getWorld(), (double)this.getPos().m_123341_() + 0.5, (double)this.getPos().m_123342_() + 0.2, (double)this.getPos().m_123343_() + 0.5, stack);
                    item.m_20334_(0.0, -1.0, 0.0);
                    item.m_32010_(40);
                    item.m_32045_(itemHandler.extractItem(i, 4, false));
                    if (!this.getWorld().m_7967_((Entity)item)) break;
                    this.items.add(item);
                    break;
                }
            });
        }
        if (this.getContainer() instanceof ConveyorTile) {
            FluidTank tank = ((ConveyorTile)this.getContainer()).getTank();
            this.getHandlerCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(arg_0 -> this.lambda$update$2((IFluidTank)tank, arg_0));
        }
    }

    private <T> LazyOptional<T> getHandlerCapability(Capability<T> capability) {
        BlockPos offsetPos = this.getPos().m_142300_(this.getSide());
        BlockEntity tile = this.getWorld().m_7702_(offsetPos);
        if (tile != null && tile.getCapability(capability, this.getSide().m_122424_()).isPresent()) {
            return tile.getCapability(capability, this.getSide().m_122424_());
        }
        Iterator iterator = this.getWorld().m_45976_(Entity.class, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82338_(offsetPos)).iterator();
        while (iterator.hasNext()) {
            Entity entity;
            if (!entity.getCapability(capability, (entity = (Entity)iterator.next()) instanceof ServerPlayer ? null : this.getSide().m_122424_()).isPresent()) continue;
            return entity.getCapability(capability, entity instanceof ServerPlayer ? null : this.getSide().m_122424_());
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.m_41712_((CompoundTag)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorExtractionUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorExtractionUpgrade.this.whitelist ? 0 : 1;
            }
        });
    }

    private /* synthetic */ void lambda$update$2(IFluidTank tank, IFluidHandler fluidHandler) {
        FluidStack drain;
        if (!fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE).isEmpty() && this.whitelist == this.filter.matches(fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE)) && (drain = fluidHandler.drain(tank.fill(fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drain.getAmount() > 0) {
            this.getContainer().requestFluidSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("extraction");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorExtractionUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_extractor_" + upgradeSide.m_7912_().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_extraction_upgrade");
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).m_126130_("IPI").m_126130_("IDI").m_126130_("ICI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).m_126127_(Character.valueOf('D'), (ItemLike)Blocks.f_50061_).m_126127_(Character.valueOf('C'), (ItemLike)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get()).m_176498_(consumer);
        }
    }
}

