/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.TransporterBlock;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.TransporterModelData;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;

public class TransporterTile
extends ActiveTile<TransporterTile>
implements IBlockContainer<TransporterTypeFactory> {
    private Map<Direction, TransporterType> transporterTypeMap = new HashMap<Direction, TransporterType>();

    public TransporterTile(BlockPos blockPos, BlockState blockState) {
        super((BasicTileBlock)((RegistryObject)ModuleTransportStorage.TRANSPORTER.getLeft()).get(), (BlockEntityType)((RegistryObject)ModuleTransportStorage.TRANSPORTER.getRight()).get(), blockPos, blockState);
    }

    @Nonnull
    public TransporterTile getSelf() {
        return this;
    }

    @Override
    public Level getBlockWorld() {
        return this.f_58857_;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.f_58858_;
    }

    @Override
    public void requestSync() {
        this.markForUpdate();
    }

    @Override
    public void requestFluidSync() {
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, TransporterTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        this.getTransporterTypeMap().values().forEach(TransporterType::update);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, TransporterTile blockEntity) {
        super.clientTick(level, pos, state, (BlockEntity)blockEntity);
        this.getTransporterTypeMap().values().forEach(TransporterType::updateClient);
    }

    @Override
    public boolean hasUpgrade(Direction facing) {
        return this.transporterTypeMap.containsKey(facing);
    }

    @Override
    public void addUpgrade(Direction facing, TransporterTypeFactory factory) {
        if (!this.hasUpgrade(facing)) {
            this.transporterTypeMap.put(facing, factory.create(this, facing, TransporterTypeFactory.TransporterAction.EXTRACT));
            this.requestSync();
            if (this.f_58857_.f_46443_) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
            }
        }
    }

    @Override
    public void removeUpgrade(Direction facing, boolean drop) {
        if (this.hasUpgrade(facing)) {
            if (!this.f_58857_.f_46443_ && drop) {
                TransporterType upgrade = this.transporterTypeMap.get(facing);
                for (ItemStack stack : upgrade.getDrops()) {
                    ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
                    item.m_32045_(stack);
                    this.f_58857_.m_7967_((Entity)item);
                }
            }
            this.transporterTypeMap.get(facing).onUpgradeRemoved();
            this.transporterTypeMap.remove(facing);
            this.requestSync();
            if (this.f_58857_.f_46443_) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
            }
        }
        if (this.transporterTypeMap.isEmpty()) {
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
        }
    }

    public void openGui(Player player, Direction facing) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, packetBuffer -> {
                packetBuffer.m_130064_(this.f_58858_);
                packetBuffer.m_130068_((Enum)facing);
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new ContainerTransporter(menu, this, (Direction)((TransporterBlock)((Object)((RegistryObject)ModuleTransportStorage.TRANSPORTER.getLeft()).get())).getFacingUpgradeHit(this.f_58857_.m_8055_(this.f_58858_), this.f_58857_, this.f_58858_, entityPlayer).getLeft(), inventoryPlayer);
    }

    @Override
    public List<Integer> getEntityFilter() {
        return Collections.emptyList();
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(TransporterModelData.UPGRADE_PROPERTY, (Object)new TransporterModelData(new HashMap<Direction, TransporterType>(this.transporterTypeMap))).build();
    }

    public Map<Direction, TransporterType> getTransporterTypeMap() {
        return this.transporterTypeMap;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        CompoundTag upgrades = new CompoundTag();
        for (Direction facing : Direction.values()) {
            if (!this.hasUpgrade(facing)) continue;
            CompoundTag upgradeTag = new CompoundTag();
            TransporterType upgrade = this.getTransporterTypeMap().get(facing);
            upgradeTag.m_128359_("factory", upgrade.getFactory().getRegistryName().toString());
            CompoundTag customNBT = upgrade.serializeNBT();
            if (customNBT != null) {
                upgradeTag.m_128365_("customNBT", (Tag)customNBT);
            }
            upgrades.m_128365_(facing.m_7912_(), (Tag)upgradeTag);
        }
        compoundTag.m_128365_("Transporters", (Tag)upgrades);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Transporters")) {
            CompoundTag upgradesTag = compound.m_128469_("Transporters");
            for (Direction facing : Direction.values()) {
                if (!upgradesTag.m_128441_(facing.m_7912_())) continue;
                CompoundTag upgradeTag = upgradesTag.m_128469_(facing.m_7912_());
                TransporterTypeFactory factory = null;
                for (TransporterTypeFactory transporterTypeFactory : TransporterTypeFactory.FACTORIES) {
                    if (!transporterTypeFactory.getRegistryName().equals((Object)new ResourceLocation(upgradeTag.m_128461_("factory")))) continue;
                    factory = transporterTypeFactory;
                    break;
                }
                if (factory == null) continue;
                TransporterType upgrade = this.transporterTypeMap.getOrDefault(facing, factory.create(this, facing, TransporterTypeFactory.TransporterAction.EXTRACT));
                if (upgradeTag.m_128441_("customNBT")) {
                    upgrade.deserializeNBT(upgradeTag.m_128469_("customNBT"));
                }
                this.transporterTypeMap.put(facing, upgrade);
            }
        }
    }
}

