/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityStackHolder;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.capability.IStackHolder;
import com.hrznstudio.titanium.capability.CapabilityItemStackHolder;
import com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack;
import com.hrznstudio.titanium.capability.ItemStackHolderCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class InfinityCapabilityProvider
implements ICapabilityProvider {
    private final FluidHandlerScreenProviderItemStack tank;
    private final InfinityEnergyStorage energyStorage;
    private final ItemStackHolderCapability itemStackHolder;
    private final LazyOptional<IEnergyStorage> energyStorageCap;
    private final LazyOptional<IFluidHandlerItem> tankCap;
    private final LazyOptional<IStackHolder> stackCap;
    private final ItemStack stack;

    public InfinityCapabilityProvider(ItemStack stack, IFactory<? extends FluidHandlerScreenProviderItemStack> tankFactory, IFactory<InfinityEnergyStorage> energyFactory) {
        this.tank = (FluidHandlerScreenProviderItemStack)tankFactory.create();
        this.energyStorage = (InfinityEnergyStorage)((Object)energyFactory.create());
        this.itemStackHolder = new InfinityStackHolder();
        this.tankCap = LazyOptional.of(() -> this.tank);
        this.energyStorageCap = LazyOptional.of(() -> this.energyStorage);
        this.stackCap = LazyOptional.of(() -> this.itemStackHolder);
        this.stack = stack;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return this.tankCap.cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyStorageCap.cast();
        }
        if (capability == CapabilityItemStackHolder.ITEMSTACK_HOLDER_CAPABILITY) {
            return this.stackCap.cast();
        }
        return LazyOptional.empty();
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

