/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.generator;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class MycelialGeneratorCategory
implements IRecipeCategory<MycelialGeneratorRecipe> {
    private final IGuiHelper guiHelper;
    private final IMycelialGeneratorType type;
    private final RecipeType<MycelialGeneratorRecipe> recipeType;
    private final IDrawable smallTank;

    public MycelialGeneratorCategory(IMycelialGeneratorType type, IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.type = type;
        this.recipeType = RecipeType.create((String)"industrialforegoing", (String)("mycelial_" + type.getName()), MycelialGeneratorRecipe.class);
        this.smallTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 238, 4, 12, 13);
    }

    public ResourceLocation getUid() {
        return this.recipeType.getUid();
    }

    public Class<? extends MycelialGeneratorRecipe> getRecipeClass() {
        return this.recipeType.getRecipeClass();
    }

    public RecipeType<MycelialGeneratorRecipe> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return new TranslatableComponent("industrialforegoing.jei.category." + this.type.getName());
    }

    public IDrawable getBackground() {
        int n = 20 * this.type.getInputs().length + 110;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return this.guiHelper.createBlankDrawable(n, 9 * 3);
    }

    public IDrawable getIcon() {
        return null;
    }

    public IMycelialGeneratorType getType() {
        return this.type;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MycelialGeneratorRecipe recipe, IFocusGroup focuses) {
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            IMycelialGeneratorType.Input input = this.type.getInputs()[i];
            if (input == IMycelialGeneratorType.Input.SLOT) {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                builder.addSlot(RecipeIngredientRole.INPUT, 20 * i + 1, 9 / 2 + 1).addItemStacks(recipe.getInputItems().get(i).stream().map(ingredient -> Arrays.asList(ingredient.m_43908_())).flatMap(Collection::stream).collect(Collectors.toList()));
                continue;
            }
            if (input != IMycelialGeneratorType.Input.TANK) continue;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            builder.addSlot(RecipeIngredientRole.INPUT, 20 * i + 3, 3 + 9 / 2).setFluidRenderer(1000, false, 12, 13).setOverlay(this.smallTank, 0, 0).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getFluidItems().get(i));
        }
    }

    public void draw(MycelialGeneratorRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            if (this.type.getInputs()[i] == IMycelialGeneratorType.Input.SLOT) {
                int finalI = i;
                Screen screen = Minecraft.m_91087_().f_91080_;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                SlotsScreenAddon.drawAsset((PoseStack)stack, (Screen)screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)(20 * i), (int)(9 / 2), (int)0, (int)0, (int)1, integer -> Pair.of((Object)1, (Object)1), integer -> ItemStack.f_41583_, (boolean)true, integer -> new Color(this.type.getInputColors()[finalI].m_41070_()), integer -> true);
                continue;
            }
            if (this.type.getInputs()[i] != IMycelialGeneratorType.Input.TANK) continue;
            Screen screen = Minecraft.m_91087_().f_91080_;
            IAsset iAsset = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            AssetUtil.drawAsset((PoseStack)stack, (Screen)screen, (IAsset)iAsset, (int)(20 * i), (int)(9 / 2));
        }
        int x = 20 * this.type.getInputs().length + 3;
        Font font = Minecraft.m_91087_().f_91062_;
        String string = ChatFormatting.DARK_GRAY + "Time: " + ChatFormatting.DARK_AQUA + new DecimalFormat().format((double)recipe.getTicks() / 20.0) + ChatFormatting.DARK_GRAY + " s";
        float f = x;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        font.m_92883_(stack, string, f, (float)(9 * 0), -1);
        Font font2 = Minecraft.m_91087_().f_91062_;
        String string2 = ChatFormatting.DARK_GRAY + "Production: " + ChatFormatting.DARK_AQUA + recipe.getPowerTick() + ChatFormatting.DARK_GRAY + " FE/t";
        float f2 = x;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        font2.m_92883_(stack, string2, f2, (float)(9 * 1), -1);
        Font font3 = Minecraft.m_91087_().f_91062_;
        String string3 = ChatFormatting.DARK_GRAY + "Total: " + ChatFormatting.DARK_AQUA + new DecimalFormat().format(recipe.getTicks() * recipe.getPowerTick()) + ChatFormatting.DARK_GRAY + " FE";
        float f3 = x;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        font3.m_92883_(stack, string3, f3, (float)(9 * 2), -1);
    }
}

