/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.black_market_tweaks.mixin;

import iskallia.vault.config.OmegaSoulShardConfig;
import iskallia.vault.config.SoulShardConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.BlackMarketRerollsPrestigePowerPower;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.world.data.PlayerBlackMarketData;
import iskallia.vault.world.data.PlayerPrestigePowersData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerBlackMarketData.BlackMarket.class}, remap=false)
public abstract class PlayerBlackMarketDataMixin {
    @Unique
    private static final int[] bmt$NORMAL = new int[]{0, 1, 3, 4};
    @Unique
    private static final int[] bmt$OMEGA = new int[]{2, 5};
    @Shadow
    @Final
    PlayerBlackMarketData this$0;
    @Shadow
    @Final
    private Map<Integer, PlayerBlackMarketData.BlackMarket.SelectedTrade> trades;
    @Shadow
    private int resetRolls;
    @Shadow
    private LocalDateTime nextReset;

    @Inject(method={"setNextReset"}, at={@At(value="HEAD")}, cancellable=true)
    private void ignoreExpertises(UUID playerUuid, CallbackInfo ci) {
        this.nextReset = LocalDateTime.now(ZoneId.of("UTC")).plusHours(ModConfigs.BLACK_MARKET.getResetHours()).plusMinutes(ModConfigs.BLACK_MARKET.getResetMinutes());
        ci.cancel();
    }

    @Inject(method={"resetTrades"}, at={@At(value="HEAD")}, cancellable=true)
    private void resetTrades(UUID playerUuid, CallbackInfo ci) {
        this.bmt$resetTrades(playerUuid, ci);
    }

    @Inject(method={"resetTradesWithoutTimer"}, at={@At(value="HEAD")}, cancellable=true)
    private void resetTradesWithoutTimer(ServerPlayer player, CallbackInfo ci) {
        this.bmt$resetTrades(player.m_142081_(), ci);
    }

    @Unique
    private void bmt$resetTrades(UUID uuid, CallbackInfo ci) {
        this.trades.clear();
        this.resetRolls = 0;
        int playerLevel = PlayerVaultStatsData.getServer().getVaultStats(uuid).getVaultLevel();
        SoulShardConfig.Trades normalTrades = null;
        for (SoulShardConfig.Trades trades : ModConfigs.SOUL_SHARD.getTrades()) {
            if (playerLevel < trades.getMinLevel() || normalTrades != null && normalTrades.getMinLevel() >= trades.getMinLevel()) continue;
            normalTrades = trades;
        }
        if (normalTrades != null) {
            for (Object i : (Object)bmt$NORMAL) {
                this.trades.put((int)i, new PlayerBlackMarketData.BlackMarket.SelectedTrade(normalTrades.getRandomTrade()).initialize(playerLevel));
            }
        }
        OmegaSoulShardConfig.Trades omegaTrades = null;
        PrestigeTree prestige = PlayerPrestigePowersData.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).getPowers(uuid);
        boolean hasPrestige = !prestige.getAll(BlackMarketRerollsPrestigePowerPower.class, Skill::isUnlocked).isEmpty();
        for (OmegaSoulShardConfig.Trades trades : ModConfigs.OMEGA_SOUL_SHARD.getTrades()) {
            if (hasPrestige) {
                if (trades.getMinLevel() < 101 || omegaTrades != null && trades.getMinLevel() <= omegaTrades.getMinLevel()) continue;
                omegaTrades = trades;
                continue;
            }
            if (playerLevel < trades.getMinLevel() || omegaTrades != null && omegaTrades.getMinLevel() >= trades.getMinLevel()) continue;
            omegaTrades = trades;
        }
        if (omegaTrades != null) {
            for (Object i : (Object)bmt$OMEGA) {
                this.trades.put((int)i, new PlayerBlackMarketData.BlackMarket.SelectedTrade(omegaTrades.getRandomTrade()).initialize(playerLevel));
            }
        }
        this.setNextReset(uuid);
        this.this$0.m_77762_();
        this.syncToClient(ServerLifecycleHooks.getCurrentServer());
        ci.cancel();
    }

    @Shadow
    public abstract void setNextReset(UUID var1);

    @Shadow
    public abstract void syncToClient(MinecraftServer var1);
}

