/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.black_market_tweaks.mixin;

import dev.attackeight.black_market_tweaks.BlackMarketTweaks;
import dev.attackeight.black_market_tweaks.extension.BlackMarketInventory;
import dev.attackeight.black_market_tweaks.init.ModConfig;
import iskallia.vault.container.inventory.ShardTradeContainer;
import iskallia.vault.container.oversized.OverSizedContainerSynchronizer;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.init.ModContainers;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShardTradeContainer.class}, remap=false)
public abstract class ShardTradeContainerMixin
extends AbstractElementContainer {
    @Unique
    private final Set<Slot> dragSlots = new HashSet<Slot>();
    @Unique
    private int dragMode = -1;
    @Unique
    private int dragEvent;

    private ShardTradeContainerMixin(int id, Inventory inventory) {
        super(ModContainers.SHARD_TRADE_CONTAINER, id, inventory.f_35978_);
    }

    @Redirect(method={"initSlots"}, at=@At(value="NEW", target="(Lnet/minecraft/world/Container;III)Lnet/minecraft/world/inventory/Slot;"))
    private Slot moveSlotsDown(Container inv, int id, int x, int y) {
        return new Slot(inv, id, x, y + 10);
    }

    @Inject(method={"initSlots"}, at={@At(value="TAIL")})
    private void addReRollSlot(Inventory playerInventory, CallbackInfo ci) {
        BlockPos lookingPos = BlackMarketTweaks.getLastClickedPos(playerInventory.f_35978_.m_142081_());
        BlockEntity be = playerInventory.f_35978_.f_19853_.m_7702_(lookingPos);
        if (be instanceof BlackMarketInventory) {
            BlackMarketInventory inventory = (BlackMarketInventory)be;
            this.m_38897_((Slot)new OverSizedTabSlot((Container)inventory.bmt$get(), 0, -21, 85).setFilter(stack -> ((String)ModConfig.ITEM.get()).equals(String.valueOf(stack.m_41720_().getRegistryName()))));
        }
    }

    public boolean m_38903_(@NotNull ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.moveOverSizedItemStackTo(stack, null, startIndex, endIndex, reverseDirection);
    }

    @Inject(method={"quickMoveStack"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void quickMoveStack(Player player, int index, CallbackInfoReturnable<ItemStack> cir) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            cir.setReturnValue((Object)ItemStack.f_41583_);
            return;
        }
        ItemStack slotStack = slot.m_7993_();
        ItemStack itemStack = slotStack.m_41777_();
        if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
            cir.setReturnValue((Object)itemStack);
            return;
        }
        if (index >= 0 && index < 27) {
            if (!this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false)) {
                cir.setReturnValue((Object)ItemStack.f_41583_);
                return;
            }
        } else if (index >= 27 && index < 36) {
            if (!this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false)) {
                cir.setReturnValue((Object)ItemStack.f_41583_);
                return;
            }
        } else if (!this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false)) {
            cir.setReturnValue((Object)ItemStack.f_41583_);
            return;
        }
        if (slotStack.m_41613_() == 0) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (slotStack.m_41613_() == itemStack.m_41613_()) {
            cir.setReturnValue((Object)ItemStack.f_41583_);
            return;
        }
        slot.m_142406_(player, slotStack);
        cir.setReturnValue((Object)itemStack);
    }

    @Unique
    protected boolean moveOverSizedItemStackTo(ItemStack sourceStack, @Nullable Slot sourceSlot, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack slotStack;
        Slot slot1;
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!sourceStack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            slot1 = (Slot)this.f_38839_.get(i);
            slotStack = slot1.m_7993_();
            if (!slotStack.m_41619_() && slotStack.m_41720_() == sourceStack.m_41720_() && ItemStack.m_41658_((ItemStack)sourceStack, (ItemStack)slotStack) && slot1.m_5857_(sourceStack)) {
                int maxSize;
                int j = slotStack.m_41613_() + sourceStack.m_41613_();
                if (j <= (maxSize = slot1.m_5866_(slotStack))) {
                    sourceStack.m_41764_(0);
                    if (sourceSlot != null) {
                        sourceSlot.m_5852_(sourceStack);
                    }
                    slotStack.m_41764_(j);
                    slot1.m_5852_(slotStack);
                    slot1.m_6654_();
                    flag = true;
                } else if (slotStack.m_41613_() < maxSize) {
                    sourceStack.m_41774_(maxSize - slotStack.m_41613_());
                    if (sourceSlot != null) {
                        sourceSlot.m_5852_(sourceStack);
                    }
                    slotStack.m_41764_(maxSize);
                    slot1.m_5852_(slotStack);
                    slot1.m_6654_();
                    flag = true;
                }
            }
            i += reverseDirection ? -1 : 1;
        }
        if (!sourceStack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot1 = (Slot)this.f_38839_.get(i);
                slotStack = slot1.m_7993_();
                if (slotStack.m_41619_() && slot1.m_5857_(sourceStack)) {
                    if (sourceStack.m_41613_() > slot1.m_5866_(sourceStack)) {
                        slot1.m_5852_(sourceStack.m_41620_(slot1.m_5866_(sourceStack)));
                    } else {
                        slot1.m_5852_(sourceStack.m_41620_(sourceStack.m_41613_()));
                    }
                    if (sourceSlot != null) {
                        sourceSlot.m_5852_(sourceStack);
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        return flag;
    }

    public void m_150399_(int slotId, int dragType, @NotNull ClickType clickTypeIn, @NotNull Player player) {
        if (clickTypeIn == ClickType.QUICK_CRAFT) {
            int j1 = this.dragEvent;
            this.dragEvent = ShardTradeContainerMixin.m_38947_((int)dragType);
            if ((j1 != 1 || this.dragEvent != 2) && j1 != this.dragEvent) {
                this.m_38951_();
            } else if (this.m_142621_().m_41619_()) {
                this.m_38951_();
            } else if (this.dragEvent == 0) {
                this.dragMode = ShardTradeContainerMixin.m_38928_((int)dragType);
                if (ShardTradeContainerMixin.m_38862_((int)this.dragMode, (Player)player)) {
                    this.dragEvent = 1;
                    this.dragSlots.clear();
                } else {
                    this.m_38951_();
                }
            } else if (this.dragEvent == 1) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                ItemStack mouseStack = this.m_142621_();
                if (slot != null && OverSizedSlotContainer.canAddItemToSlot((Slot)slot, (ItemStack)mouseStack, (boolean)true) && slot.m_5857_(mouseStack) && (this.dragMode == 2 || mouseStack.m_41613_() > this.dragSlots.size()) && this.m_5622_(slot)) {
                    this.dragSlots.add(slot);
                }
            } else if (this.dragEvent == 2) {
                if (!this.dragSlots.isEmpty()) {
                    ItemStack slotStack = this.m_142621_().m_41777_();
                    int k1 = this.m_142621_().m_41613_();
                    Iterator<Slot> var21 = this.dragSlots.iterator();
                    while (true) {
                        if (!var21.hasNext()) {
                            slotStack.m_41764_(k1);
                            this.m_142503_(slotStack);
                            break;
                        }
                        Slot dragSlot = var21.next();
                        ItemStack mouseStack2 = this.m_142621_();
                        if (dragSlot == null || !OverSizedSlotContainer.canAddItemToSlot((Slot)dragSlot, (ItemStack)mouseStack2, (boolean)true) || !dragSlot.m_5857_(mouseStack2) || this.dragMode != 2 && mouseStack2.m_41613_() < this.dragSlots.size() || !this.m_5622_(dragSlot)) continue;
                        ItemStack itemstack14 = slotStack.m_41777_();
                        int j3 = dragSlot.m_6657_() ? dragSlot.m_7993_().m_41613_() : 0;
                        ShardTradeContainerMixin.m_38922_(this.dragSlots, (int)this.dragMode, (ItemStack)itemstack14, (int)j3);
                        int k3 = dragSlot.m_5866_(itemstack14);
                        if (itemstack14.m_41613_() > k3) {
                            itemstack14.m_41764_(k3);
                        }
                        k1 -= itemstack14.m_41613_() - j3;
                        dragSlot.m_5852_(itemstack14);
                    }
                }
                this.m_38951_();
            } else {
                this.m_38951_();
            }
        } else if (this.dragEvent != 0) {
            this.m_38951_();
        } else if (clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1) {
            if (clickTypeIn != ClickType.SWAP || dragType < 0 || dragType >= 9) {
                if (clickTypeIn == ClickType.CLONE && player.m_150110_().f_35937_ && this.m_142621_().m_41619_() && slotId >= 0) {
                    Slot slot = (Slot)this.f_38839_.get(slotId);
                    if (slot != null && slot.m_6657_()) {
                        ItemStack slotStack = slot.m_7993_().m_41777_();
                        slotStack.m_41764_(slotStack.m_41741_());
                        this.m_142503_(slotStack);
                    }
                } else if (clickTypeIn == ClickType.THROW && this.m_142621_().m_41619_() && slotId >= 0) {
                    Slot slot = (Slot)this.f_38839_.get(slotId);
                    if (slot != null && slot.m_6657_() && slot.m_8010_(player)) {
                        int removeCount = Math.min(dragType == 0 ? 1 : slot.m_7993_().m_41613_(), slot.m_7993_().m_41741_());
                        ItemStack mouseStack = slot.m_6201_(removeCount);
                        slot.m_142406_(player, mouseStack);
                        player.m_36176_(mouseStack, true);
                    }
                } else if (clickTypeIn == ClickType.PICKUP_ALL && slotId >= 0) {
                    Slot slot = (Slot)this.f_38839_.get(slotId);
                    ItemStack slotStack = this.m_142621_();
                    if (!(slotStack.m_41619_() || slot != null && slot.m_6657_() && slot.m_8010_(player))) {
                        int k1 = dragType == 0 ? 0 : this.f_38839_.size() - 1;
                        int j2 = dragType == 0 ? 1 : -1;
                        for (int k = 0; k < 2; ++k) {
                            for (int l = k1; l >= 0 && l < this.f_38839_.size() && slotStack.m_41613_() < slotStack.m_41741_(); l += j2) {
                                Slot slot1 = (Slot)this.f_38839_.get(l);
                                if (!slot1.m_6657_() || !OverSizedSlotContainer.canAddItemToSlot((Slot)slot1, (ItemStack)slotStack, (boolean)true) || !slot1.m_8010_(player) || !this.m_5882_(slotStack, slot1)) continue;
                                ItemStack itemstack2 = slot1.m_7993_();
                                if (k == 0 && itemstack2.m_41613_() >= slot1.m_5866_(itemstack2)) continue;
                                int k3 = Math.min(slotStack.m_41741_() - slotStack.m_41613_(), itemstack2.m_41613_());
                                ItemStack itemstack3 = slot1.m_6201_(k3);
                                slotStack.m_41769_(k3);
                                if (itemstack3.m_41619_()) {
                                    slot1.m_5852_(ItemStack.f_41583_);
                                }
                                slot1.m_142406_(player, itemstack3);
                            }
                        }
                    }
                    this.m_38946_();
                }
            }
        } else if (slotId == -999) {
            if (!this.m_142621_().m_41619_()) {
                if (dragType == 0) {
                    player.m_36176_(this.m_142621_(), true);
                    this.m_142503_(ItemStack.f_41583_);
                }
                if (dragType == 1) {
                    player.m_36176_(this.m_142621_().m_41620_(1), true);
                }
            }
        } else if (clickTypeIn == ClickType.QUICK_MOVE) {
            if (slotId < 0) {
                return;
            }
            Slot slot = (Slot)this.f_38839_.get(slotId);
            if (slot == null || !slot.m_8010_(player)) {
                return;
            }
            ItemStack slotStack = this.m_7648_(player, slotId);
            while (!slotStack.m_41619_() && ItemStack.m_41746_((ItemStack)slot.m_7993_(), (ItemStack)slotStack)) {
                slotStack = this.m_7648_(player, slotId);
            }
        } else {
            if (slotId < 0) {
                return;
            }
            Slot slot = (Slot)this.f_38839_.get(slotId);
            if (slot != null) {
                ItemStack slotStack = slot.m_7993_();
                ItemStack mouseStack = this.m_142621_();
                if (slotStack.m_41619_()) {
                    if (!mouseStack.m_41619_() && slot.m_5857_(mouseStack)) {
                        int j2;
                        int n = j2 = dragType == 0 ? mouseStack.m_41613_() : 1;
                        if (j2 > slot.m_5866_(mouseStack)) {
                            j2 = slot.m_5866_(mouseStack);
                        }
                        slot.m_5852_(mouseStack.m_41620_(j2));
                    }
                } else if (slot.m_8010_(player)) {
                    int j2;
                    if (mouseStack.m_41619_()) {
                        if (slotStack.m_41619_()) {
                            slot.m_5852_(ItemStack.f_41583_);
                            this.m_142503_(ItemStack.f_41583_);
                        } else {
                            int j22 = Math.min(slotStack.m_41613_(), slotStack.m_41741_());
                            int k = dragType == 0 ? j22 : (j22 + 1) / 2;
                            this.m_142503_(slot.m_6201_(k));
                            if (slotStack.m_41619_()) {
                                slot.m_5852_(ItemStack.f_41583_);
                            }
                            slot.m_142406_(player, this.m_142621_());
                        }
                    } else if (slot.m_5857_(mouseStack)) {
                        if (slotStack.m_41720_() == mouseStack.m_41720_() && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)mouseStack)) {
                            int j23;
                            int n = j23 = dragType == 0 ? mouseStack.m_41613_() : 1;
                            if (j23 > slot.m_5866_(mouseStack) - slotStack.m_41613_()) {
                                j23 = slot.m_5866_(mouseStack) - slotStack.m_41613_();
                            }
                            mouseStack.m_41774_(j23);
                            slotStack.m_41769_(j23);
                            slot.m_5852_(slotStack);
                        } else if (mouseStack.m_41613_() <= slot.m_5866_(mouseStack) && slotStack.m_41613_() <= slotStack.m_41741_()) {
                            slot.m_5852_(mouseStack);
                            this.m_142503_(slotStack);
                        }
                    } else if (slotStack.m_41720_() == mouseStack.m_41720_() && mouseStack.m_41741_() > 1 && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)mouseStack) && !slotStack.m_41619_() && (j2 = slotStack.m_41613_()) + mouseStack.m_41613_() <= mouseStack.m_41741_()) {
                        mouseStack.m_41769_(j2);
                        slotStack = slot.m_6201_(j2);
                        if (slotStack.m_41619_()) {
                            slot.m_5852_(ItemStack.f_41583_);
                        }
                        slot.m_142406_(player, this.m_142621_());
                    }
                }
                slot.m_6654_();
            }
        }
    }

    protected void m_38951_() {
        this.dragEvent = 0;
        this.dragSlots.clear();
    }

    public void m_150416_(@NotNull ContainerSynchronizer sync) {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            super.m_150416_((ContainerSynchronizer)new OverSizedContainerSynchronizer(sync, sPlayer));
        } else {
            super.m_150416_(sync);
        }
    }
}

