/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.black_market_tweaks.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.attackeight.black_market_tweaks.gui.CountDownElement;
import dev.attackeight.black_market_tweaks.gui.LateInitLegendaryParticle;
import dev.attackeight.black_market_tweaks.init.ModConfig;
import dev.attackeight.black_market_tweaks.init.ModTextures;
import iskallia.vault.client.ClientExpertiseData;
import iskallia.vault.client.ClientShardTradeData;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.ItemStackDisplayElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRendererFactory;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.ShardTradeScreen;
import iskallia.vault.container.inventory.ShardTradeContainer;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.ItemShardPouch;
import iskallia.vault.network.message.ServerboundResetBlackMarketTradesMessage;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.expertise.type.BlackMarketExpertise;
import iskallia.vault.util.LegendaryScreenParticle;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShardTradeScreen.class}, priority=1, remap=false)
public abstract class ShardTradeScreenMixin
extends AbstractElementContainerScreen<ShardTradeContainer> {
    @Unique
    private static final int[] bmt$PARTICLE_COLORS = new int[]{-8185907, -9037875, -9758771, -10545203, -11397171};
    @Unique
    private static final Style bmt$TITLE_TEXT = Style.f_131099_.m_178520_(-12632257);
    @Unique
    private static final Style bmt$ENABLED_TEXT = Style.f_131099_.m_178520_(0xFFFFFF);
    @Unique
    private static final Style bmt$DISABLED_TEXT = Style.f_131099_.m_178520_(0x7E0000);
    @Unique
    private static final NumberFormat bmt$NUMBER_FORMAT = NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT);
    @Unique
    private static final Component RESET_TIME = new TextComponent("00:00:00");
    @Shadow
    @Mutable
    @Final
    private LabelElement<?> labelRandomTrade;
    @Shadow
    protected LegendaryScreenParticle screenParticleLeft;
    @Shadow
    protected LegendaryScreenParticle screenParticleRight;
    @Shadow
    private ButtonElement<?> omegaButton;
    @Shadow
    @Mutable
    @Final
    private LabelElement<?>[] labelShopTrades;
    @Unique
    private LateInitLegendaryParticle[] bmt$particles;
    @Unique
    private ButtonElement<?>[] bmt$omegaButtons;
    @Unique
    protected LabelElement<?> bmt$soulShardCount;
    @Shadow
    private float dt;

    private ShardTradeScreenMixin(ShardTradeContainer container, Inventory inventory, Component title, IElementRenderer elementRenderer, ITooltipRendererFactory<AbstractElementContainerScreen<ShardTradeContainer>> tooltipRendererFactory) {
        super((AbstractContainerMenu)container, inventory, title, elementRenderer, tooltipRendererFactory);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(ShardTradeContainer container, Inventory inventory, Component title, CallbackInfo ci) {
        this.elementStore.removeAllElements();
        this.labelShopTrades = new LabelElement[6];
        this.bmt$particles = new LateInitLegendaryParticle[]{this.bmt$createParticle(27, 74, 150.0f, 210.0f), this.bmt$createParticle(132, 74, 150.0f, 210.0f), this.bmt$createParticle(117, 74, -30.0f, 30.0f), this.bmt$createParticle(222, 74, -30.0f, 30.0f)};
        this.bmt$omegaButtons = new ButtonElement[2];
        ISpatial guiSpatial = this.getGuiSpatial();
        this.addElement((IElement)((TextureAtlasElement)new TextureAtlasElement((IPosition)guiSpatial, ModTextures.BLACK_MARKET_BACKGROUND).layout((screen, gui, parent, world) -> world.translateXY(gui.left() - 55, gui.top()).size((ISize)Spatials.copy((ISpatial)gui)))));
        this.addElement((IElement)((LabelElement)new LabelElement((IPosition)Spatials.positionXY((int)-47, (int)7), (Component)new TextComponent("Black Market").m_130948_(bmt$TITLE_TEXT), LabelTextStyle.defaultStyle()).layout(this::bmt$translateToGui)));
        this.addElement((IElement)((SlotsElement)new SlotsElement((MenuAccess)this).layout(this::bmt$translateToGui)));
        int countdownWidth = ScreenTextures.TAB_COUNTDOWN_BACKGROUND.width();
        int countdownHeight = ScreenTextures.TAB_COUNTDOWN_BACKGROUND.height();
        int resetWidth = ((Font)TextBorder.DEFAULT_FONT.get()).m_92852_((FormattedText)RESET_TIME);
        IMutableSpatial resetPosition = Spatials.positionXYZ((int)(guiSpatial.width() / 2 - resetWidth / 2 - 11), (int)-10, (int)200);
        this.addElement((IElement)((CountDownElement)new CountDownElement((IPosition)resetPosition, (ISize)Spatials.size((int)resetWidth, (int)9)).layout(this::bmt$translateToGui)));
        ((TextureAtlasElement)((TextureAtlasElement)this.addElement((IElement)new TextureAtlasElement((IPosition)Spatials.positionXY((int)(guiSpatial.width() / 2 - countdownWidth / 2 - 10), (int)(-countdownHeight)), ScreenTextures.TAB_COUNTDOWN_BACKGROUND))).tooltip(() -> new TextComponent("Shop resets in"))).layout(this::bmt$translateToGui);
        ((ItemStackDisplayElement)this.addElement((IElement)((ItemStackDisplayElement)new ItemStackDisplayElement((ISpatial)Spatials.positionXY((int)(guiSpatial.width() / 2 - countdownWidth - 37), (int)(-countdownHeight + 3)), new ItemStack((ItemLike)ModItems.SOUL_SHARD)).layout(this::bmt$translateToGui)))).setScale(0.8f);
        Slot rerollSlot = (Slot)((ShardTradeContainer)this.f_97732_).f_38839_.get(36);
        this.addElement((IElement)((ButtonElement)((ButtonElement)new ButtonElement((IPosition)Spatials.positionXY((int)(guiSpatial.width() / 2 - countdownWidth / 2 + 50), (int)(-countdownHeight)), ScreenTextures.BUTTON_RESET_TRADES_TEXTURES, () -> {
            ModNetwork.CHANNEL.sendToServer((Object)ServerboundResetBlackMarketTradesMessage.INSTANCE);
            ((ShardTradeContainer)this.f_97732_).getPlayer().f_19853_.m_6263_(((ShardTradeContainer)this.f_97732_).getPlayer(), ((ShardTradeContainer)this.f_97732_).getPlayer().m_20185_(), ((ShardTradeContainer)this.f_97732_).getPlayer().m_20186_(), ((ShardTradeContainer)this.f_97732_).getPlayer().m_20189_(), ModSounds.SKILL_TREE_LEARN_SFX, SoundSource.BLOCKS, 0.75f, 1.0f);
        }).setDisabled(() -> !rerollSlot.m_6657_()).tooltip(() -> {
            int numOfRollsLeft = rerollSlot.m_7993_().m_41613_();
            return numOfRollsLeft > 0 ? new TextComponent("Rolls Left: " + numOfRollsLeft) : new TextComponent("Put an item in the re-roll slot to re-roll");
        })).layout(this::bmt$translateToGui)));
        this.addElement((IElement)((TextureAtlasElement)new TextureAtlasElement((IPosition)Spatials.positionXY((int)-26, (int)80), ModTextures.BLACK_MARKET_REROLL_ORNAMENT).layout(this::bmt$translateToGui)));
        this.addElement((IElement)((TextureAtlasElement)((TextureAtlasElement)new TextureAtlasElement((IPosition)Spatials.positionXY((int)(guiSpatial.width() / 2 - countdownWidth - 40), (int)(-countdownHeight)), ScreenTextures.TAB_COUNTDOWN_BACKGROUND).tooltip(() -> new TextComponent("Number of Soul Shards in Inventory"))).layout(this::bmt$translateToGui)));
        this.bmt$soulShardCount = (LabelElement)((LabelElement)this.addElement((IElement)new LabelElement((IPosition)Spatials.positionXYZ((int)(guiSpatial.width() / 2 - countdownWidth - 8), (int)(-countdownHeight + 5), (int)200), TextComponent.f_131282_, LabelTextStyle.shadow().center()))).layout(this::bmt$translateToGui);
        this.labelRandomTrade = (LabelElement)((LabelElement)this.addElement((IElement)new LabelElement((IPosition)Spatials.positionXYZ((int)-13, (int)64, (int)200), TextComponent.f_131282_, LabelTextStyle.border8().center()))).layout(this::bmt$translateToGui);
        this.addElement((IElement)((ItemStackDisplayElement)new ItemStackDisplayElement(guiSpatial, new ItemStack((ItemLike)ModItems.SOUL_SHARD)).layout((screen, gui, parent, world) -> world.positionXY(gui.left() - 21, gui.top() + 54))));
        this.addElement((IElement)((TextureAtlasElement)new TextureAtlasElement((IPosition)Spatials.positionXY((int)-37, (int)18), ScreenTextures.SOUL_SHARD_TRADE_ORNAMENT).layout(this::bmt$translateToGui)));
        this.addElement((IElement)((FakeItemSlotElement)((FakeItemSlotElement)new FakeItemSlotElement((ISpatial)Spatials.positionXY((int)-21, (int)34), () -> new ItemStack((ItemLike)ModItems.UNKNOWN_ITEM), () -> !this.canBuyRandomTrade()).whenClicked(this::buyRandomTrade).tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            tooltipRenderer.renderTooltip(poseStack, new ItemStack((ItemLike)ModItems.UNKNOWN_ITEM), mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        })).layout(this::bmt$translateToGui)));
        this.addElement((IElement)((LabelElement)new LabelElement((IPosition)Spatials.positionXY((int)8, (int)110), this.f_169604_, LabelTextStyle.defaultStyle()).layout(this::bmt$translateToGui)));
        for (int trade = 1; trade <= 6; ++trade) {
            int index = trade - 1;
            int xIndex = index < 3 ? 0 : 1;
            int yIndex = index % 3;
            boolean omega = yIndex == 2;
            int xOffset = (index < 3 ? 0 : 105) - (omega ? 1 : 0);
            int yOffset = yIndex * 33 - (omega ? 1 : 0);
            if (yIndex == 0) {
                this.addElement((IElement)((TextureAtlasElement)new TextureAtlasElement((IPosition)guiSpatial, ModTextures.BLACK_MARKET_ORNAMENT).layout((screen, gui, parent, world) -> world.positionXY(gui.left() + 24 + xOffset, gui.top() + 6))));
            } else if (omega) {
                this.addElement((IElement)((TextureAtlasElement)new TextureAtlasElement((IPosition)guiSpatial, ScreenTextures.OMEGA_BLACK_MARKET_ORNAMENT).layout((screen, gui, parent, world) -> world.positionXY(gui.left() + 23 + xOffset, gui.top() + 70))));
            }
            ButtonElement button = (ButtonElement)this.addElement((IElement)new ButtonElement((IPosition)Spatials.positionXY((int)(28 + xOffset), (int)(10 + yOffset)), omega ? ScreenTextures.OMEGA_BUTTON_TRADE_WIDE_TEXTURES : ScreenTextures.BUTTON_TRADE_WIDE_TEXTURES, () -> {}));
            button.setDisabled(() -> !this.canBuyTrade(index));
            button.tooltip(() -> new TextComponent("Learn Marketer Expertise to Unlock"));
            button.layout(this::bmt$translateToGui);
            button.setEnabled(!this.bmt$hasTrade(trade));
            if (omega) {
                this.bmt$omegaButtons[xIndex] = button;
            }
            this.addElement((IElement)((ItemStackDisplayElement)new ItemStackDisplayElement(guiSpatial, new ItemStack((ItemLike)ModItems.SOUL_SHARD)).layout((screen, gui, parent, world) -> world.translateXY(gui.left() + 39 + xOffset, gui.top() + 14 + yOffset))));
            this.labelShopTrades[index] = (LabelElement)((LabelElement)this.addElement((IElement)new LabelElement((IPosition)Spatials.positionXYZ((int)(47 + xOffset), (int)(14 + yOffset + 10), (int)200), TextComponent.f_131282_, LabelTextStyle.border8().center()))).layout(this::bmt$translateToGui);
            ((FakeItemSlotElement)((FakeItemSlotElement)this.addElement((IElement)new FakeItemSlotElement((ISpatial)Spatials.positionXY((int)(91 + xOffset), (int)(14 + yOffset)), () -> {
                Tuple info = ClientShardTradeData.getTradeInfo((int)index);
                return info == null ? ItemStack.f_41583_ : ((ItemStack)info.m_14418_()).m_41777_();
            }, () -> !this.canBuyTrade(index)))).setLabelStackCount().whenClicked(() -> {
                if (omega) {
                    this.bmt$particles[xIndex].pop(4.0f, 20.0f);
                    this.bmt$particles[xIndex + 2].pop(4.0f, 20.0f);
                }
                this.buyTrade(index);
            }).tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                Tuple info = ClientShardTradeData.getTradeInfo((int)index);
                if (info != null && !((ItemStack)info.m_14418_()).m_41619_()) {
                    tooltipRenderer.renderTooltip(poseStack, (ItemStack)info.m_14418_(), mouseX, mouseY, TooltipDirection.RIGHT);
                }
                return true;
            })).layout(this::bmt$translateToGui);
        }
        this.updateTradeLabels();
        this.screenParticleLeft = this.bmt$particles[0];
        this.screenParticleRight = this.bmt$particles[2];
        this.omegaButton = this.bmt$omegaButtons[0];
    }

    @Inject(method={"updateTradeLabels"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateLabels(CallbackInfo ci) {
        int playerShards = ItemShardPouch.getShardCount((Player)((ShardTradeContainer)this.f_97732_).getPlayer());
        this.bmt$setCostLabel(this.labelRandomTrade, playerShards, ClientShardTradeData.getRandomTradeCost());
        for (int i = 0; i < this.labelShopTrades.length; ++i) {
            Tuple tradeInfo = ClientShardTradeData.getTradeInfo((int)i);
            if (tradeInfo == null) {
                this.labelShopTrades[i].set(TextComponent.f_131282_);
                continue;
            }
            this.bmt$setCostLabel(this.labelShopTrades[i], playerShards, (Integer)tradeInfo.m_14419_());
        }
        if (this.bmt$soulShardCount != null) {
            this.bmt$soulShardCount.set(bmt$NUMBER_FORMAT.format(playerShards));
        }
        ci.cancel();
    }

    @Unique
    private void bmt$setCostLabel(LabelElement<?> label, int shards, int cost) {
        label.set((Component)new TextComponent(String.valueOf(cost)).m_130948_(shards >= cost ? bmt$ENABLED_TEXT : bmt$DISABLED_TEXT));
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.needsLayout) {
            this.layout(Spatials.zero());
            this.needsLayout = false;
        }
        this.renderBackgroundFill(poseStack);
        this.renderElements(poseStack, mouseX, mouseY, partialTick);
        this.renderSlotItems(poseStack, mouseX, mouseY, partialTick);
        this.renderDebug(poseStack);
        for (int i = 0; i < this.bmt$particles.length / 2; ++i) {
            LateInitLegendaryParticle left = this.bmt$particles[i];
            LateInitLegendaryParticle right = this.bmt$particles[i + 2];
            left.init((AbstractContainerScreen<?>)this);
            right.init((AbstractContainerScreen<?>)this);
            this.dt += partialTick;
            while (this.dt >= 0.5f) {
                left.tick();
                right.tick();
                int trade = (i + 1) * 3;
                if (ClientShardTradeData.getTradeInfo((int)(trade - 1)) != null) {
                    left.pop();
                    right.pop();
                }
                this.dt -= 0.5f;
            }
            left.render(poseStack, partialTick);
            right.render(poseStack, partialTick);
        }
        this.renderTooltips(poseStack, mouseX, mouseY);
        ci.cancel();
    }

    @Inject(method={"canBuyTrade"}, at={@At(value="HEAD")}, cancellable=true)
    private void canBuyTrade(int tradeIndex, CallbackInfoReturnable<Boolean> cir) {
        Tuple tradeInfo = ClientShardTradeData.getTradeInfo((int)tradeIndex);
        cir.setReturnValue((Object)(tradeInfo != null && ItemShardPouch.getShardCount((Player)((ShardTradeContainer)this.f_97732_).getPlayer()) >= (Integer)tradeInfo.m_14419_() && this.bmt$hasTrade(tradeIndex + 1) ? 1 : 0));
    }

    @Unique
    private boolean bmt$hasTrade(int trade) {
        if (trade <= (Integer)ModConfig.BASE_TRADES.get()) {
            return true;
        }
        int level = trade - (Integer)ModConfig.BASE_TRADES.get();
        for (TieredSkill skill : ClientExpertiseData.getLearnedTalentNodes()) {
            if (!(skill.getChild() instanceof BlackMarketExpertise) || skill.getSpentLearnPoints() < level) continue;
            return true;
        }
        return false;
    }

    @Unique
    private LateInitLegendaryParticle bmt$createParticle(int xOffset, int yOffset, float min, float max) {
        return (LateInitLegendaryParticle)new LateInitLegendaryParticle((AbstractContainerScreen<?>)this, xOffset, yOffset).spawnedWidthHeight(0, 28).angleRange(min, max).quantityRange(1, 2).delayRange(0, 10).lifespanRange(10, 50).sizeRange(1, 4).speedRange(0.05f, 0.45f).particleColours(bmt$PARTICLE_COLORS);
    }

    @Unique
    private void bmt$translateToGui(ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) {
        world.translateXY((IPosition)gui);
    }

    @Shadow
    protected abstract void updateTradeLabels();

    @Shadow
    protected abstract boolean canBuyTrade(int var1);

    @Shadow
    protected abstract void buyTrade(int var1);

    @Shadow
    protected abstract boolean canBuyRandomTrade();

    @Shadow
    protected abstract void buyRandomTrade();

    static {
        bmt$NUMBER_FORMAT.setMaximumFractionDigits(1);
    }
}

