/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderFissionReactor
extends MekanismTileEntityRenderer<TileEntityFissionReactorCasing> {
    private static final Map<RenderData, MekanismRenderer.Model3D> cachedHeatedCoolantModels = new Object2ObjectOpenHashMap();
    private static final int GLOW_ARGB = MekanismRenderer.getColorARGB((float)0.466f, (float)0.882f, (float)0.929f, (float)0.6f);
    private static MekanismRenderer.Model3D glowModel;

    public static void resetCachedModels() {
        cachedHeatedCoolantModels.clear();
        glowModel = null;
    }

    public RenderFissionReactor(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityFissionReactorCasing tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        FissionReactorMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (FissionReactorMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null) {
            int height;
            int glow;
            FluidRenderData data;
            int height2;
            BlockPos pos = tile.m_58899_();
            VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
            if (multiblock.isBurning()) {
                if (glowModel == null) {
                    glowModel = new MekanismRenderer.Model3D();
                    RenderFissionReactor.glowModel.minX = 0.05f;
                    RenderFissionReactor.glowModel.minY = 0.01f;
                    RenderFissionReactor.glowModel.minZ = 0.05f;
                    RenderFissionReactor.glowModel.maxX = 0.95f;
                    RenderFissionReactor.glowModel.maxY = 0.99f;
                    RenderFissionReactor.glowModel.maxZ = 0.95f;
                    glowModel.setTexture(MekanismRenderer.whiteIcon);
                }
                for (FissionReactorValidator.FormedAssembly assembly : multiblock.assemblies) {
                    matrix.m_85836_();
                    matrix.m_85837_((double)(assembly.pos().m_123341_() - pos.m_123341_()), (double)(assembly.pos().m_123342_() - pos.m_123342_()), (double)(assembly.pos().m_123343_() - pos.m_123343_()));
                    matrix.m_85841_(1.0f, (float)assembly.height(), 1.0f);
                    MekanismRenderer.renderObject((MekanismRenderer.Model3D)glowModel, (PoseStack)matrix, (VertexConsumer)buffer, (int)GLOW_ARGB, (int)0xF000F0, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT);
                    matrix.m_85849_();
                }
            }
            if (!multiblock.fluidCoolantTank.isEmpty() && (height2 = multiblock.height() - 2) >= 1) {
                data = new FluidRenderData(multiblock.fluidCoolantTank.getFluid());
                glow = this.setCoolantDataAndCalculateGlow((RenderData)data, multiblock, height2);
                matrix.m_85836_();
                matrix.m_85837_((double)(data.location.m_123341_() - pos.m_123341_()), (double)(data.location.m_123342_() - pos.m_123342_()), (double)(data.location.m_123343_() - pos.m_123343_()));
                MekanismRenderer.Model3D model = ModelRenderer.getModel((RenderData)data, (double)multiblock.prevCoolantScale);
                MekanismRenderer.renderObject((MekanismRenderer.Model3D)model, (PoseStack)matrix, (VertexConsumer)buffer, (int)data.getColorARGB(multiblock.prevCoolantScale), (int)glow, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)this.getFaceDisplay((RenderData)data, model));
                matrix.m_85849_();
                MekanismRenderer.renderValves((PoseStack)matrix, (VertexConsumer)buffer, (Set)multiblock.valves, (FluidRenderData)data, (BlockPos)pos, (int)glow, (int)overlayLight, (BooleanSupplier)this.isInsideMultiblock((RenderData)data));
            }
            if (!multiblock.heatedCoolantTank.isEmpty() && (height = multiblock.height() - 2) >= 1) {
                MekanismRenderer.Model3D gasModel;
                data = new ChemicalRenderData.GasRenderData((GasStack)multiblock.heatedCoolantTank.getStack());
                glow = this.setCoolantDataAndCalculateGlow((RenderData)data, multiblock, height);
                if (cachedHeatedCoolantModels.containsKey(data)) {
                    gasModel = cachedHeatedCoolantModels.get(data);
                } else {
                    gasModel = ModelRenderer.getModel((RenderData)data, (double)1.0).copy();
                    gasModel.minX += 0.01f;
                    gasModel.minY += 0.01f;
                    gasModel.minZ += 0.01f;
                    gasModel.maxX -= 0.01f;
                    gasModel.maxY -= 0.01f;
                    gasModel.maxZ -= 0.01f;
                    cachedHeatedCoolantModels.put((RenderData)data, gasModel);
                }
                matrix.m_85836_();
                matrix.m_85837_((double)(data.location.m_123341_() - pos.m_123341_()), (double)(data.location.m_123342_() - pos.m_123342_()), (double)(data.location.m_123343_() - pos.m_123343_()));
                MekanismRenderer.renderObject((MekanismRenderer.Model3D)gasModel, (PoseStack)matrix, (VertexConsumer)buffer, (int)data.getColorARGB(multiblock.prevHeatedCoolantScale), (int)glow, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)this.getFaceDisplay((RenderData)data, gasModel));
                matrix.m_85849_();
            }
        }
    }

    private int setCoolantDataAndCalculateGlow(RenderData data, FissionReactorMultiblockData multiblock, int height) {
        data.location = multiblock.renderLocation;
        data.height = height;
        data.length = multiblock.length();
        data.width = multiblock.width();
        return data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
    }

    protected String getProfilerSection() {
        return "fissionReactor";
    }

    public boolean shouldRenderOffScreen(TileEntityFissionReactorCasing tile) {
        if (tile.isMaster()) {
            FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && multiblock.renderLocation != null;
        }
        return false;
    }
}

