/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import xyz.iwolfking.vhapi.api.LoaderRegistry;
import xyz.iwolfking.vhapi.api.events.vault.VaultEvents;
import xyz.iwolfking.vhapi.api.registry.VaultGearRegistry;
import xyz.iwolfking.vhapi.api.registry.VaultObjectiveRegistry;
import xyz.iwolfking.vhapi.api.util.ResourceLocUtils;
import xyz.iwolfking.vhapi.api.util.vhapi.VHAPILoggerUtils;
import xyz.iwolfking.vhapi.api.util.vhapi.VHAPIUtils;
import xyz.iwolfking.vhapi.config.VHAPIConfig;
import xyz.iwolfking.vhapi.mixin.accessors.BountyScreenAccessor;
import xyz.iwolfking.vhapi.networking.VHAPISyncDescriptor;
import xyz.iwolfking.vhapi.networking.VHAPISyncNetwork;
import xyz.iwolfking.vhapi.proxy.IVHAPISyncProxy;
import xyz.iwolfking.vhapi.proxy.client.VHAPISyncClientProxy;
import xyz.iwolfking.vhapi.proxy.server.VHAPISyncServerProxy;

@Mod(value="vhapi")
public class VHAPI {
    public static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicBoolean hasLoaded = new AtomicBoolean();
    public static final String MODID = "vhapi";
    public static final IVHAPISyncProxy PROXY = (IVHAPISyncProxy)DistExecutor.safeRunForDist(() -> VHAPISyncClientProxy::new, () -> VHAPISyncServerProxy::new);

    public VHAPI() {
        VHAPILoggerUtils.debug("Initializing VHAPI!");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VHAPIConfig.SERVER_SPEC, "vhapi-server.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VHAPIConfig.COMMON_SPEC, "vhapi-common.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::worldLoad);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onLogin);
        MinecraftForge.EVENT_BUS.addListener(LoaderRegistry::onAddListener);
        modEventBus.addListener(VaultObjectiveRegistry::newRegistry);
        modEventBus.addListener(VaultGearRegistry::newRegistry);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.addListener(Client::onClientLogin);
            MinecraftForge.EVENT_BUS.addListener(Client::onClientLogout);
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        VaultEvents.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        if (((Boolean)VHAPIConfig.SERVER.syncDatapackConfigs.get()).booleanValue()) {
            PROXY.init();
        }
    }

    public static ResourceLocation of(String name) {
        return new ResourceLocation(MODID, name);
    }

    private void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            if (((Boolean)VHAPIConfig.SERVER.syncDatapackConfigs.get()).booleanValue()) {
                VHAPILoggerUtils.info("Sending VHAPI datapacks to " + event.getPlayer().m_7755_().getString() + ".");
                VHAPISyncNetwork.syncVHAPIConfigs(new VHAPISyncDescriptor(LoaderRegistry.VHAPI_DATA_LOADER.getCompressedConfigMap()), (ServerPlayer)event.getPlayer());
            }
        });
    }

    private void worldLoad(WorldEvent.Load event) {
        if (event.getWorld().m_5776_()) {
            if (BountyScreenAccessor.getObjectiveNames() != null) {
                BountyScreenAccessor.getObjectiveNames().putAll(VaultObjectiveRegistry.CUSTOM_BOUNTY_SCREEN_NAMES);
            }
            return;
        }
        if (this.hasLoaded.get()) {
            return;
        }
        if (this.hasLoaded.compareAndSet(false, true)) {
            // empty if block
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="vhapi")
    public static class Client {
        public static final Map<String, List<ResourceLocation>> CUSTOM_TEXTURE_ATLAS_MAP = new HashMap<String, List<ResourceLocation>>();

        public static void onClientLogin(ClientPlayerNetworkEvent.LoggedInEvent event) {
            VHAPILoggerUtils.debug("Rerunning Vault Configs load client-side to patch them.");
            VHAPIUtils.loadConfigs();
            if (BountyScreenAccessor.getObjectiveNames() != null) {
                BountyScreenAccessor.getObjectiveNames().putAll(VaultObjectiveRegistry.CUSTOM_BOUNTY_SCREEN_NAMES);
            }
        }

        public static void onClientLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            VHAPILoggerUtils.debug("Clearing cached config data.");
            VHAPIUtils.purgeConfigs();
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void textureStitch(TextureStitchEvent.Pre event) {
            if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
                Client.addSpritesToAtlas("MODIFIERS", "/textures/gui/modifiers");
                Client.addSpritesToAtlas("ABILITY", "/textures/gui/abilities");
                Client.addSpritesToAtlas("RESEARCH", "/textures/gui/researches");
                Client.addSpritesToAtlas("RESEARCH_GROUP", "/textures/gui/research_groups");
                Client.addSpritesToAtlas("SKILLS", "/textures/gui/skills");
                Collection gearTextures = Minecraft.m_91087_().m_91098_().m_6540_("textures/item/gear", s -> s.endsWith(".png"));
                if (gearTextures.isEmpty()) {
                    return;
                }
                for (ResourceLocation loc : gearTextures) {
                    if (loc.m_135827_().equals("the_vault")) continue;
                    VHAPILoggerUtils.debug("Stitching custom transmog texture: " + String.valueOf(loc));
                    event.addSprite(ResourceLocUtils.stripLocationForSprite(loc));
                }
            }
        }

        private static void addSpritesToAtlas(String type, String directory) {
            Collection textures = Minecraft.m_91087_().m_91098_().m_6540_(directory, s -> s.endsWith(".png"));
            ArrayList<ResourceLocation> textureLocations = new ArrayList<ResourceLocation>();
            if (textures.isEmpty()) {
                return;
            }
            for (ResourceLocation loc : textures) {
                textureLocations.add(ResourceLocUtils.stripLocationForSprite(loc));
            }
            CUSTOM_TEXTURE_ATLAS_MAP.put(type, textureLocations);
        }
    }
}

