/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import xyz.iwolfking.vhapi.api.events.ConfigDataLoaderEvent;
import xyz.iwolfking.vhapi.api.events.VHAPIProcessorsEvent;
import xyz.iwolfking.vhapi.api.lib.core.processors.IConfigProcessor;
import xyz.iwolfking.vhapi.api.loaders.Processors;
import xyz.iwolfking.vhapi.api.loaders.lib.VHAPIDataLoader;
import xyz.iwolfking.vhapi.api.loaders.lib.core.GenFileProcessor;
import xyz.iwolfking.vhapi.api.loaders.lib.core.VaultConfigProcessor;
import xyz.iwolfking.vhapi.api.util.vhapi.VHAPILoggerUtils;

@Mod.EventBusSubscriber(modid="vhapi", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LoaderRegistry {
    private static int ordinal = -1;
    public static final Map<Integer, IConfigProcessor> CONFIG_PROCESSORS = new HashMap<Integer, IConfigProcessor>();
    public static final Map<ResourceLocation, GenFileProcessor<?>> GEN_FILE_LOADERS = new HashMap();
    public static final VHAPIDataLoader VHAPI_DATA_LOADER = new VHAPIDataLoader();

    public static void onAddListener(AddReloadListenerEvent event) {
        VHAPILoggerUtils.info("Registering VHAPI datapack listener!");
        event.addListener((PreparableReloadListener)VHAPI_DATA_LOADER);
        MinecraftForge.EVENT_BUS.post((Event)new ConfigDataLoaderEvent.Finish(VHAPI_DATA_LOADER));
    }

    public static void addConfigProcessor(IConfigProcessor processor) {
        MinecraftForge.EVENT_BUS.addListener(processor::afterConfigsLoad);
        CONFIG_PROCESSORS.put(++ordinal, processor);
    }

    public static void initProcessors() {
        MinecraftForge.EVENT_BUS.post((Event)new VHAPIProcessorsEvent.Init());
        for (VaultConfigProcessor<?> transmogProcessor : Processors.TransmogConfigProcessors.getStandardTransmogProcessors()) {
            LoaderRegistry.addConfigProcessor(transmogProcessor);
        }
        LoaderRegistry.addConfigProcessor(Processors.GenerationFileProcessors.GEN_PALETTE_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GenerationConfigProcessors.PALETTES_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GenerationFileProcessors.GEN_TEMPLATE_POOL_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GenerationConfigProcessors.TEMPLATE_POOLS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GenerationFileProcessors.GEN_LOOT_TABLE_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GenerationConfigProcessors.LOOT_TABLE_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.RecipesConfigProcessors.CATALYST_RECIPES_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.RecipesConfigProcessors.INSCRIPTION_RECIPES_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.RecipesConfigProcessors.TRINKET_RECIPES_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.RecipesConfigProcessors.TOOL_RECIPES_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.RecipesConfigProcessors.GEAR_RECIPES_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.RecipesConfigProcessors.JEWEL_CRAFTING_RECIPES_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.BuiltInLootBoxConfigProcessors.MOD_BOX_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.BuiltInLootBoxConfigProcessors.MYSTERY_BOX_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.BuiltInLootBoxConfigProcessors.MYSTERY_EGG_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.BuiltInLootBoxConfigProcessors.MYSTERY_HOSTILE_EGG_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.BuiltInLootBoxConfigProcessors.UNIDENTIFIED_TREASURE_KEY_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultGearConfigProcessors.CUSTOM_VAULT_GEAR_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultGearConfigProcessors.CUSTOM_VAULT_GEAR_WORKBENCH_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultGearConfigProcessors.GEAR_MODEL_ROLL_RARITIES_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultGearConfigProcessors.CUSTOM_GEAR_MODEL_ROLL_RARITIES_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultGearConfigProcessors.GEAR_ENCHANTMENT_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultGearConfigProcessors.TRINKET_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultGearConfigProcessors.UNIQUE_GEAR_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultModifierConfigProcessors.VAULT_MODIFIER_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultModifierConfigProcessors.VAULT_MODIFIER_POOLS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ResearchConfigProcessors.RESEARCH_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ResearchConfigProcessors.RESEARCH_GROUP_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ResearchConfigProcessors.RESEARCH_GUI_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ResearchConfigProcessors.RESEARCH_GROUP_GUI_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ObjectiveConfigProcessors.BINGO_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ObjectiveConfigProcessors.ELIXIR_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ObjectiveConfigProcessors.MONOLITH_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ObjectiveConfigProcessors.SCAVENGER_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.ABILITIES_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.ABILITIES_GUI_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.ABILITIES_DESCRIPTIONS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.SKILL_GATES_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.SKILL_DESCRIPTIONS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.TALENT_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.TALENTS_GUI_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.EXPERTISE_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.SkillConfigProcessors.EXPERTISES_GUI_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.CardConfigProcessors.BOOSTER_PACKS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.CardConfigProcessors.CARD_ESSENCE_EXTRACTOR_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.CardConfigProcessors.CARD_MODIFIERS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.CardConfigProcessors.CARD_TASKS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.CardConfigProcessors.DECKS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ToolConfigProcessors.PULVERIZING_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.VaultAltarIngredientConfigProcessors.VAULT_ALTAR_INGREDIENTS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.WorkstationConfigProcessors.VAULT_RECYCLER_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.WorkstationConfigProcessors.VAULT_DIFFUSER_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.WorkstationConfigProcessors.BOUNTY_REWARDS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ShopConfigProcessors.SHOPPING_PEDESTAL_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ShopConfigProcessors.NORMAL_BLACK_MARKET_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.ShopConfigProcessors.OMEGA_BLACK_MARKET_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GenerationFileProcessors.GEN_THEME_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GenerationConfigProcessors.THEME_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.AUGMENT_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.INSCRIPTION_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.CATALYST_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_CRYSTAL_CATALYST_MODIFIERS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_CHEST_META_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_GENERAL_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_LEVELS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_MOBS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_PORTAL_BLOCK_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.TOOLTIP_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_STATS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.LEGACY_LOOT_TABLE_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.LOOT_INFO_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.CHAMPIONS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.ENTITY_GROUPS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.TILE_GROUPS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.CUSTOM_TITLE_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.CUSTOM_ENTITY_SPAWNERS_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.RAID_ACTIONS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.TRANSLATIONS_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_ALTAR_CONFIG_LOADER);
        LoaderRegistry.addConfigProcessor(Processors.GeneralVaultConfigProcessors.VAULT_CRYSTAL_CONFIG_LOADER);
        MinecraftForge.EVENT_BUS.post((Event)new VHAPIProcessorsEvent.End());
    }
}

