/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.api.lib.core.readers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import iskallia.vault.config.Config;
import iskallia.vault.init.ModConfigs;
import java.lang.reflect.Type;
import xyz.iwolfking.vhapi.VHAPI;
import xyz.iwolfking.vhapi.api.data.core.ConfigData;
import xyz.iwolfking.vhapi.api.util.vhapi.VHAPILoggerUtils;
import xyz.iwolfking.vhapi.mixin.accessors.MixinConfigAccessor;

public class CustomVaultConfigReader<T extends Config> {
    public static final Gson GSON = ConfigData.CONFIG_LOADER_GSON;

    public T readCustomConfig(String name, JsonElement json, Type instance) {
        Config readConfig;
        VHAPILoggerUtils.debug(String.format("Reading custom %s config: %s", instance.getTypeName().toLowerCase(), name));
        try {
            Config config = (Config)GSON.fromJson(json, instance);
            ((MixinConfigAccessor)config).invokeOnLoad(config);
            if (!((MixinConfigAccessor)config).invokeIsValid()) {
                VHAPI.LOGGER.error("Invalid config {}, using defaults", (Object)this);
                ModConfigs.INVALID_CONFIGS.add(((MixinConfigAccessor)config).invokeGetConfigFile().getName() + " - There was an invalid setting in this config.");
                ((MixinConfigAccessor)config).invokeReset();
            }
            readConfig = config;
        }
        catch (JsonSyntaxException e) {
            throw new RuntimeException(e);
        }
        return (T)readConfig;
    }
}

