/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.api.loaders.box;

import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.util.data.WeightedList;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import xyz.iwolfking.vhapi.api.events.VaultConfigEvent;
import xyz.iwolfking.vhapi.api.loaders.box.lib.MappedWeightedProductEntryConfig;
import xyz.iwolfking.vhapi.api.loaders.lib.core.VaultConfigProcessor;

public class MappedWeightedProductEntryConfigLoader
extends VaultConfigProcessor<MappedWeightedProductEntryConfig> {
    Supplier<Map<String, WeightedList<ProductEntry>>> targetPool;

    public MappedWeightedProductEntryConfigLoader(Supplier<Map<String, WeightedList<ProductEntry>>> POOL, String name) {
        super(new MappedWeightedProductEntryConfig(), "loot_box/" + name);
        this.targetPool = POOL;
    }

    @Override
    public void afterConfigsLoad(VaultConfigEvent.End event) {
        for (MappedWeightedProductEntryConfig config : this.CUSTOM_CONFIGS.values()) {
            for (String modKey : config.POOL.keySet()) {
                HashSet entriesToRemove = new HashSet();
                if (this.targetPool.get().containsKey(modKey)) {
                    config.POOL.get(modKey).forEach(productEntryEntry -> {
                        if (((ProductEntry)productEntryEntry.value).getNBT() != null && ((ProductEntry)productEntryEntry.value).getNBT().m_128441_("remove")) {
                            entriesToRemove.add(((ProductEntry)productEntryEntry.value).getItem());
                        } else {
                            this.targetPool.get().get(modKey).add(productEntryEntry);
                        }
                    });
                    HashSet<ProductEntry> productsToRemove = new HashSet<ProductEntry>();
                    for (WeightedList.Entry entry : this.targetPool.get().get(modKey)) {
                        if (!entriesToRemove.contains(((ProductEntry)entry.value).getItem())) continue;
                        productsToRemove.add((ProductEntry)entry.value);
                    }
                    for (ProductEntry removeEntry : productsToRemove) {
                        this.targetPool.get().get(modKey).removeEntry((Object)removeEntry);
                    }
                    continue;
                }
                this.targetPool.get().put(modKey, config.POOL.get(modKey));
            }
        }
        super.afterConfigsLoad(event);
    }
}

