/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.api.loaders.box;

import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.util.data.WeightedList;
import java.util.HashSet;
import java.util.function.Supplier;
import xyz.iwolfking.vhapi.api.events.VaultConfigEvent;
import xyz.iwolfking.vhapi.api.loaders.box.lib.WeightedProductEntryConfig;
import xyz.iwolfking.vhapi.api.loaders.lib.core.VaultConfigProcessor;

public class WeightedProductEntryConfigLoader
extends VaultConfigProcessor<WeightedProductEntryConfig> {
    Supplier<WeightedList<ProductEntry>> targetPool;

    public WeightedProductEntryConfigLoader(Supplier<WeightedList<ProductEntry>> POOL, String name) {
        super(new WeightedProductEntryConfig(), "loot_box/" + name);
        this.targetPool = POOL;
    }

    @Override
    public void afterConfigsLoad(VaultConfigEvent.End event) {
        for (WeightedProductEntryConfig config : this.CUSTOM_CONFIGS.values()) {
            HashSet entriesToRemove = new HashSet();
            config.POOL.forEach((productEntry, weight) -> {
                if (productEntry.getNBT().m_128441_("remove")) {
                    entriesToRemove.add(productEntry.getItem());
                } else {
                    this.targetPool.get().add(productEntry, ((Integer)weight).intValue());
                }
            });
            HashSet<ProductEntry> productsToRemove = new HashSet<ProductEntry>();
            for (WeightedList.Entry entry : this.targetPool.get()) {
                if (!entriesToRemove.contains(((ProductEntry)entry.value).getItem())) continue;
                productsToRemove.add((ProductEntry)entry.value);
            }
            for (WeightedList.Entry entry : productsToRemove) {
                this.targetPool.get().removeEntry((Object)entry);
            }
        }
        super.afterConfigsLoad(event);
    }
}

