/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.api.loaders.lib;

import com.google.gson.JsonElement;
import iskallia.vault.init.ModConfigs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import xyz.iwolfking.vhapi.api.LoaderRegistry;
import xyz.iwolfking.vhapi.api.data.core.ConfigData;
import xyz.iwolfking.vhapi.api.lib.core.processors.IConfigProcessor;
import xyz.iwolfking.vhapi.api.lib.core.processors.IPreProcessor;
import xyz.iwolfking.vhapi.api.util.vhapi.VHAPILoggerUtils;
import xyz.iwolfking.vhapi.config.VHAPIConfig;
import xyz.iwolfking.vhapi.networking.util.StringCompressor;

public class VHAPIDataLoader
extends SimpleJsonResourceReloadListener {
    private boolean isInitialized = false;
    private final String namespace = "vhapi";
    public Map<ResourceLocation, JsonElement> JSON_DATA = new HashMap<ResourceLocation, JsonElement>();
    private final Set<ResourceLocation> CONFIGS_TO_IGNORE = new HashSet<ResourceLocation>();

    public VHAPIDataLoader() {
        super(ConfigData.CONFIG_LOADER_GSON, "vault_configs");
    }

    protected void apply(Map<ResourceLocation, JsonElement> dataMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        profilerFiller.m_7242_();
        dataMap.forEach((resourceLocation, jsonElement) -> {
            if (!this.getIgnoredConfigs().contains(resourceLocation)) {
                this.JSON_DATA.put(new ResourceLocation("vhapi", resourceLocation.m_135815_()), (JsonElement)jsonElement);
            }
        });
        profilerFiller.m_6180_("process_vault_configs");
        this.gatherConfigsToProcessors();
        profilerFiller.m_7238_();
        profilerFiller.m_7241_();
        VHAPILoggerUtils.info("Finished processing " + dataMap.size() + " custom vault configs.");
    }

    public void addIgnoredConfig(ResourceLocation configLocation) {
        this.CONFIGS_TO_IGNORE.add(configLocation);
    }

    public Set<ResourceLocation> getIgnoredConfigs() {
        Set<ResourceLocation> locations = this.CONFIGS_TO_IGNORE;
        locations.addAll(VHAPIConfig.COMMON.getIgnoredConfigs());
        return locations;
    }

    public Map<ResourceLocation, byte[]> getCompressedConfigMap() {
        HashMap<ResourceLocation, byte[]> returnMap = new HashMap<ResourceLocation, byte[]>();
        for (ResourceLocation loc : this.JSON_DATA.keySet()) {
            if (this.getIgnoredConfigs().contains(loc)) continue;
            returnMap.put(loc, StringCompressor.compress(this.JSON_DATA.get(loc).toString()));
        }
        return returnMap;
    }

    public void gatherConfigsToProcessors() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            LoaderRegistry.initProcessors();
        }
        for (int i = 0; i < LoaderRegistry.CONFIG_PROCESSORS.size(); ++i) {
            IConfigProcessor configProcessor = LoaderRegistry.CONFIG_PROCESSORS.get(i);
            configProcessor.processMatchingConfigs();
            if (!(configProcessor instanceof IPreProcessor)) continue;
            IPreProcessor preConfigProcessor = (IPreProcessor)((Object)configProcessor);
            preConfigProcessor.preProcessStep();
        }
        ModConfigs.register();
    }
}

