/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.api.registry;

import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModItems;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.vhapi.api.registry.gear.CustomVaultGearRegistryEntry;
import xyz.iwolfking.vhapi.mixin.accessors.ReforgeTagModificationFocusAccessor;

public class VaultGearRegistry {
    public static Supplier<IForgeRegistry<CustomVaultGearRegistryEntry>> customGearRegistry;

    public static void newRegistry(NewRegistryEvent event) {
        RegistryBuilder builder = new RegistryBuilder().setType(CustomVaultGearRegistryEntry.class).setName(new ResourceLocation("vhapi", "custom_gear_registry")).add((IForgeRegistry.AddCallback)new Callback());
        customGearRegistry = event.create(builder);
    }

    public static ItemLike[] getItemLikes() {
        HashSet<Item> itemLikeList = new HashSet<Item>();
        for (CustomVaultGearRegistryEntry entry : customGearRegistry.get().getValues()) {
            itemLikeList.add(entry.getRegistryItem());
        }
        itemLikeList.addAll(List.of(ModItems.HELMET, ModItems.CHESTPLATE, ModItems.LEGGINGS, ModItems.BOOTS, ModItems.AXE, ModItems.SWORD, ModItems.SHIELD, ModItems.IDOL_BENEVOLENT, ModItems.IDOL_OMNISCIENT, ModItems.IDOL_TIMEKEEPER, ModItems.IDOL_MALEVOLENCE, ModItems.MAGNET, ModItems.WAND, ModItems.FOCUS));
        return itemLikeList.toArray(new ItemLike[0]);
    }

    public static class Callback
    implements IForgeRegistry.AddCallback<CustomVaultGearRegistryEntry> {
        public void onAdd(IForgeRegistryInternal<CustomVaultGearRegistryEntry> iForgeRegistryInternal, RegistryManager registryManager, int i, CustomVaultGearRegistryEntry customGearRegistryEntry, @Nullable CustomVaultGearRegistryEntry v1) {
            if (ReforgeTagModificationFocusAccessor.getItemToName() != null) {
                ReforgeTagModificationFocusAccessor.getItemToName().put(customGearRegistryEntry.getRegistryItem(), customGearRegistryEntry.getName());
            }
            ModDynamicModels.REGISTRIES.associate(customGearRegistryEntry.getRegistryItem(), customGearRegistryEntry.getDynamicModelRegistry());
        }
    }
}

