/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.api.registry;

import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.item.crystal.CrystalData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.vhapi.api.registry.objective.CustomObjectiveRegistryEntry;
import xyz.iwolfking.vhapi.mixin.accessors.KeyRegistryAccessor;
import xyz.iwolfking.vhapi.mixin.accessors.LootInfoGroupDefinitionRegistryAccessor;

@Mod.EventBusSubscriber
public class VaultObjectiveRegistry {
    public static Supplier<IForgeRegistry<CustomObjectiveRegistryEntry>> customObjectiveRegistry;
    public static Map<String, TextComponent> CUSTOM_BOUNTY_SCREEN_NAMES;
    public static Set<CustomObjectiveRegistryEntry> ENTRIES;

    public static void newRegistry(NewRegistryEvent event) {
        RegistryBuilder builder = new RegistryBuilder().setType(CustomObjectiveRegistryEntry.class).setName(new ResourceLocation("vhapi", "custom_objective_registry")).add((IForgeRegistry.AddCallback)new Callback());
        customObjectiveRegistry = event.create(builder);
    }

    static {
        CUSTOM_BOUNTY_SCREEN_NAMES = new HashMap<String, TextComponent>();
        ENTRIES = new HashSet<CustomObjectiveRegistryEntry>();
    }

    public static class Callback
    implements IForgeRegistry.AddCallback<CustomObjectiveRegistryEntry> {
        public void onAdd(IForgeRegistryInternal<CustomObjectiveRegistryEntry> iForgeRegistryInternal, RegistryManager registryManager, int i, CustomObjectiveRegistryEntry customObjectiveRegistryEntry, @Nullable CustomObjectiveRegistryEntry v1) {
            if (ENTRIES.contains((Object)customObjectiveRegistryEntry)) {
                return;
            }
            ENTRIES.add(customObjectiveRegistryEntry);
            ((KeyRegistryAccessor)VaultRegistry.OBJECTIVE).setLocked(false);
            VaultRegistry.OBJECTIVE.register(customObjectiveRegistryEntry.getKey());
            CrystalData.OBJECTIVE.register(customObjectiveRegistryEntry.getId(), customObjectiveRegistryEntry.getCrystalObjective(), customObjectiveRegistryEntry.getCrystalObjectiveSupplier());
            CUSTOM_BOUNTY_SCREEN_NAMES.put(customObjectiveRegistryEntry.getId(), new TextComponent(customObjectiveRegistryEntry.getName()));
            if (customObjectiveRegistryEntry.getCrateItem() != null) {
                LootInfoGroupDefinitionRegistryAccessor.invokeRegister("completion_crate_" + customObjectiveRegistryEntry.getId(), () -> new ItemStack(customObjectiveRegistryEntry.getCrateItem()));
            }
        }
    }
}

