/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.api.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import xyz.iwolfking.vhapi.api.LoaderRegistry;
import xyz.iwolfking.vhapi.api.util.JsonUtils;

public class VHAPIProcesserUtils {
    public static void addManualConfigFile(Path path, ResourceLocation resourceLocation) {
        VHAPIProcesserUtils.addManualConfigFile(path.toFile(), resourceLocation);
    }

    public static void addManualConfigFile(File file, ResourceLocation resourceLocation) {
        try (FileReader reader = new FileReader(file);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            VHAPIProcesserUtils.addToLoader(resourceLocation, jsonElement);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addManualConfigFile(InputStream stream, ResourceLocation resourceLocation) {
        VHAPIProcesserUtils.addToLoader(resourceLocation, JsonUtils.parseJsonContentFromStream(stream));
    }

    private static void addToLoader(ResourceLocation location, JsonElement element) {
        if (LoaderRegistry.VHAPI_DATA_LOADER.getIgnoredConfigs().contains(location)) {
            return;
        }
        LoaderRegistry.VHAPI_DATA_LOADER.JSON_DATA.put(location, element);
    }
}

