/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class VHAPIConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)serverSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Boolean> syncDatapackConfigs;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Main Settings");
            this.syncDatapackConfigs = builder.comment("Whether the server should attempt to sync configs with clients with VHAPI installed. (default: true)").define("syncDatapackConfigs", true);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledConfigs;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Main Settings");
            this.disabledConfigs = builder.comment("List of resource locations that should not be loaded via VHAPI.").defineList("disabledConfigs", List.of(), entry -> ResourceLocation.m_135830_((String)((String)entry)));
            builder.pop();
        }

        public List<ResourceLocation> getIgnoredConfigs() {
            ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
            for (String config : (List)this.disabledConfigs.get()) {
                locations.add(new ResourceLocation(config));
            }
            return locations;
        }
    }
}

