/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.mixin.registry.gear;

import com.llamalad7.mixinextras.sugar.Local;
import iskallia.vault.config.Config;
import iskallia.vault.config.GearModelRollRaritiesConfig;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.item.gear.VaultArmorItem;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.vhapi.api.data.api.CustomGearModelRolls;

@Mixin(value={GearModelRollRaritiesConfig.class}, remap=false)
public abstract class MixinGearModelRollRaritiesConfig
extends Config {
    @Shadow
    public abstract Map<String, List<String>> getRolls(ItemStack var1);

    @Shadow
    @Nullable
    protected abstract VaultGearRarity getForcedTierRarity(ItemStack var1, ResourceLocation var2);

    @Inject(method={"getRolls"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRollsHook(CallbackInfoReturnable<Map<String, List<String>>> cir, @Local ItemStack stack) {
        if (CustomGearModelRolls.CUSTOM_MODEL_ROLLS_MAP.containsKey(stack.m_41720_().getRegistryName())) {
            cir.setReturnValue(CustomGearModelRolls.CUSTOM_MODEL_ROLLS_MAP.get(stack.m_41720_().getRegistryName()));
        }
    }

    @Overwrite
    public VaultGearRarity getRarityOf(ItemStack stack, ResourceLocation modelId) {
        Map<String, List<String>> rolls = this.getRolls(stack);
        if (rolls == null) {
            return VaultGearRarity.SCRAPPY;
        }
        VaultGearRarity predefined = this.getForcedTierRarity(stack, modelId);
        if (predefined != null) {
            return predefined;
        }
        if (stack.m_41720_() instanceof VaultArmorItem) {
            modelId = ModDynamicModels.Armor.PIECE_REGISTRY.get(modelId).map(ArmorPieceModel::getArmorModel).map(DynamicModel::getId).orElse(modelId);
        }
        for (int i = VaultGearRarity.values().length - 1; i >= 0; --i) {
            VaultGearRarity rarity = VaultGearRarity.values()[i];
            List<String> modelIds = rolls.get(rarity.name());
            if (modelIds == null) {
                modelIds = rolls.get(rarity);
            }
            if (modelIds == null || !modelIds.contains(modelId.toString())) continue;
            return rarity;
        }
        return VaultGearRarity.SCRAPPY;
    }
}

