/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.networking;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import xyz.iwolfking.vhapi.api.LoaderRegistry;
import xyz.iwolfking.vhapi.api.util.vhapi.VHAPILoggerUtils;
import xyz.iwolfking.vhapi.networking.util.StringCompressor;

public class VHAPISyncDescriptor {
    private final Map<ResourceLocation, byte[]> configsMap;
    public static final BiConsumer<VHAPISyncDescriptor, FriendlyByteBuf> ENCODER = (message, buffer) -> buffer.m_178355_(message.configsMap, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130087_);
    public static final Function<FriendlyByteBuf, VHAPISyncDescriptor> DECODER = buffer -> new VHAPISyncDescriptor(buffer.m_178368_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::m_130052_));
    public static final BiConsumer<VHAPISyncDescriptor, Supplier<NetworkEvent.Context>> CONSUMER = (message, context) -> {
        NetworkEvent.Context cont = (NetworkEvent.Context)context.get();
        message.handle(cont);
    };

    public VHAPISyncDescriptor(Map<ResourceLocation, byte[]> configsMap) {
        this.configsMap = configsMap;
    }

    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            VHAPILoggerUtils.info("Received VHAPI sync packet, handling...");
            HashMap<ResourceLocation, JsonElement> loadedConfigs = new HashMap<ResourceLocation, JsonElement>();
            try {
                Map<ResourceLocation, byte[]> compressedJsonMap = this.configsMap;
                for (ResourceLocation loc : compressedJsonMap.keySet()) {
                    String rawJsonString = StringCompressor.decompress(compressedJsonMap.get(loc));
                    if (rawJsonString == null) {
                        VHAPILoggerUtils.info("Received config from server that was unexpectedly null: " + String.valueOf(loc));
                        throw new RuntimeException();
                    }
                    loadedConfigs.put(loc, JsonParser.parseString((String)rawJsonString));
                }
            }
            catch (Exception e) {
                VHAPILoggerUtils.info("Failed to receive datapacks from server.");
                throw new RuntimeException(e);
            }
            LoaderRegistry.VHAPI_DATA_LOADER.JSON_DATA.putAll(loadedConfigs);
            LoaderRegistry.VHAPI_DATA_LOADER.gatherConfigsToProcessors();
        });
        context.setPacketHandled(true);
    }
}

