/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.vhapi.networking.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class StringCompressor {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(String stringToCompress) {
        if (Objects.isNull(stringToCompress) || stringToCompress.isEmpty()) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzipOutput = new GZIPOutputStream(baos);){
                gzipOutput.write(stringToCompress.getBytes(StandardCharsets.UTF_8));
                gzipOutput.finish();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while compression!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String decompress(byte[] compressed) {
        if (Objects.isNull(compressed) || compressed.length == 0) {
            return null;
        }
        try (GZIPInputStream gzipInput = new GZIPInputStream(new ByteArrayInputStream(compressed));){
            String string;
            try (StringWriter stringWriter = new StringWriter();){
                IOUtils.copy((InputStream)gzipInput, (Writer)stringWriter, (Charset)StandardCharsets.UTF_8);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while decompression!", e);
        }
    }
}

